/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.util;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.mixin.structure.jigsaw.JigsawStructureAccessor;
import com.faboslav.structurify.common.platform.PlatformHooks;
import com.telepathicgrunt.repurposedstructures.world.structures.GenericJigsawStructure;
import com.yungnickyoung.minecraft.yungsapi.world.structure.YungJigsawStructure;
import java.lang.reflect.Field;
import java.util.Optional;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;

public final class JigsawStructureUtil {
    public static boolean isJigsawLikeStructure(Structure structure) {
        Field[] fields;
        if (structure instanceof JigsawStructure) {
            return true;
        }
        if (PlatformHooks.PLATFORM_HELPER.isModLoaded("yungsapi") && structure instanceof YungJigsawStructure) {
            return true;
        }
        if (PlatformHooks.PLATFORM_HELPER.isModLoaded("repurposed_structures") && structure instanceof GenericJigsawStructure) {
            return true;
        }
        Class<?> clazz = structure.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.getName().equals("maxDistanceFromCenter") && !field.getName().equals("maxDepth") && !field.getName().equals("size")) continue;
            return true;
        }
        return false;
    }

    public static int getMaxDistanceFromCenterForStructure(Structure structure) {
        Field[] fields;
        if (structure instanceof JigsawStructure) {
            return ((JigsawStructureAccessor)structure).structurify$getMaxDistanceFromCenter();
        }
        if (PlatformHooks.PLATFORM_HELPER.isModLoaded("yungsapi") && structure instanceof YungJigsawStructure) {
            return ((YungJigsawStructure)structure).maxDistanceFromCenter;
        }
        if (PlatformHooks.PLATFORM_HELPER.isModLoaded("repurposed_structures") && structure instanceof GenericJigsawStructure) {
            return ((GenericJigsawStructure)structure).maxDistanceFromCenter.orElse(0);
        }
        Class<?> clazz = structure.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.getName().equals("maxDistanceFromCenter")) continue;
            field.setAccessible(true);
            try {
                if (Optional.class.isAssignableFrom(field.getType())) {
                    Optional optionalValue = (Optional)field.get(structure);
                    return optionalValue.map(val -> (Integer)val).orElse(0);
                }
                return field.getInt(structure);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                Structurify.getLogger().error(e.getMessage());
                break;
            }
        }
        return 0;
    }

    public static int getSizeForStructure(Structure structure) {
        Field[] fields;
        if (structure instanceof JigsawStructure) {
            return ((JigsawStructureAccessor)structure).structurify$getMaxDepth();
        }
        if (PlatformHooks.PLATFORM_HELPER.isModLoaded("yungsapi") && structure instanceof YungJigsawStructure) {
            return ((YungJigsawStructure)structure).maxDepth;
        }
        if (PlatformHooks.PLATFORM_HELPER.isModLoaded("repurposed_structures") && structure instanceof GenericJigsawStructure) {
            return ((GenericJigsawStructure)structure).size;
        }
        Class<?> clazz = structure.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.getName().equals("size") && !field.getName().equals("max_depth")) continue;
            field.setAccessible(true);
            try {
                if (Optional.class.isAssignableFrom(field.getType())) {
                    Optional optionalValue = (Optional)field.get(structure);
                    return optionalValue.map(val -> (Integer)val).orElse(0);
                }
                return field.getInt(structure);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                Structurify.getLogger().error(e.getMessage());
                break;
            }
        }
        return 0;
    }
}

