/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.data;

import com.faboslav.structurify.common.api.StructurifyRandomSpreadStructurePlacement;
import com.faboslav.structurify.common.api.StructurifyStructurePlacement;
import com.faboslav.structurify.common.config.data.StructureData;
import com.faboslav.structurify.common.config.data.StructureNamespaceData;
import com.faboslav.structurify.common.config.data.StructureSetData;
import com.faboslav.structurify.common.config.data.structure.FlatnessCheckData;
import com.faboslav.structurify.common.config.data.structure.JigsawData;
import com.faboslav.structurify.common.registry.StructurifyRegistryManagerProvider;
import com.faboslav.structurify.common.util.JigsawStructureUtil;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_5434;
import net.minecraft.class_6862;
import net.minecraft.class_6874;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7059;
import net.minecraft.class_7225;
import net.minecraft.class_7924;

public final class WorldgenDataProvider {
    private static List<String> biomes = new ArrayList<String>();
    private static Map<String, StructureNamespaceData> structureNamespaceData = new TreeMap<String, StructureNamespaceData>();
    private static Map<String, StructureData> structureData = new TreeMap<String, StructureData>();
    private static Map<String, StructureSetData> structureSetData = new TreeMap<String, StructureSetData>();
    private static final Comparator<String> alphabeticallComparator = (key1, key2) -> {
        boolean isKey1Minecraft = key1.startsWith("minecraft:");
        boolean isKey2Minecraft = key2.startsWith("minecraft:");
        if (isKey1Minecraft && !isKey2Minecraft) {
            return -1;
        }
        if (!isKey1Minecraft && isKey2Minecraft) {
            return 1;
        }
        return key1.compareTo((String)key2);
    };

    public static List<String> getBiomes() {
        return biomes;
    }

    public static Map<String, StructureNamespaceData> getStructureNamespaces() {
        return structureNamespaceData;
    }

    public static Map<String, StructureData> getStructures() {
        return structureData;
    }

    public static Map<String, StructureSetData> getStructureSets() {
        return structureSetData;
    }

    public static void loadWorldgenData() {
        biomes = WorldgenDataProvider.loadBiomes();
        structureNamespaceData = WorldgenDataProvider.loadStructureNamespaces();
        structureData = WorldgenDataProvider.loadStructures();
        structureSetData = WorldgenDataProvider.loadStructureSets();
    }

    public static List<String> loadBiomes() {
        class_7225.class_7226<class_1959> biomeRegistry = StructurifyRegistryManagerProvider.getBiomeRegistry();
        if (biomeRegistry == null) {
            return Collections.emptyList();
        }
        ArrayList<String> biomes = new ArrayList<String>();
        for (class_6885.class_6888 biomeTag : biomeRegistry.method_42020().toList()) {
            biomes.add("#" + ((class_6862)biomeTag.method_45925().get()).comp_327().toString());
        }
        for (class_6880.class_6883 biome : biomeRegistry.method_42017().toList()) {
            biomes.add(((class_5321)biome.method_40230().get()).method_29177().toString());
        }
        return biomes;
    }

    public static Map<String, StructureNamespaceData> loadStructureNamespaces() {
        class_7225.class_7874 registryManager = StructurifyRegistryManagerProvider.getRegistryManager();
        if (registryManager == null) {
            return Collections.emptyMap();
        }
        class_7225.class_7226 structureRegistry = registryManager.method_46762(class_7924.field_41246);
        TreeMap<String, StructureNamespaceData> structuresNamespaces = new TreeMap<String, StructureNamespaceData>(alphabeticallComparator);
        for (class_6880.class_6883 structureReference : structureRegistry.method_42017().toList()) {
            String structureNamespace = structureReference.method_40237().method_29177().method_12836();
            if (structuresNamespaces.containsKey(structureNamespace)) continue;
            structuresNamespaces.put(structureNamespace, new StructureNamespaceData());
        }
        structuresNamespaces.put(StructureNamespaceData.GLOBAL_NAMESPACE_IDENTIFIER, new StructureNamespaceData());
        return structuresNamespaces;
    }

    public static Map<String, StructureData> loadStructures() {
        class_7225.class_7874 registryManager = StructurifyRegistryManagerProvider.getRegistryManager();
        if (registryManager == null) {
            return Collections.emptyMap();
        }
        class_7225.class_7226 structureRegistry = registryManager.method_46762(class_7924.field_41246);
        class_7225.class_7226 biomeRegistry = registryManager.method_46762(class_7924.field_41236);
        TreeMap<String, StructureData> structures = new TreeMap<String, StructureData>(alphabeticallComparator);
        for (class_6880.class_6883 structureReference : structureRegistry.method_42017().toList()) {
            List<String> biomes2;
            class_3195 structure = (class_3195)structureReference.comp_349();
            String structureId = structureReference.method_40237().method_29177().toString();
            Either biomeStorage = structure.method_41607().method_40248();
            ArrayList<String> defaultBiomes = new ArrayList<String>();
            biomeStorage.mapLeft(biomeTagKey -> {
                biomeRegistry.method_46733(biomeTagKey).ifPresent(biomes -> {
                    for (class_6880 biome : biomes) {
                        String biomeKey = ((class_5321)biome.method_40230().get()).method_29177().toString();
                        if (defaultBiomes.contains(biomeKey)) continue;
                        defaultBiomes.add(biomeKey);
                    }
                });
                return null;
            });
            biomeStorage.mapRight(biomes -> {
                for (class_6880 biome : biomes) {
                    String biomeKey = ((class_5321)biome.method_40230().get()).method_29177().toString();
                    if (defaultBiomes.contains(biomeKey)) continue;
                    defaultBiomes.add(biomeKey);
                }
                return null;
            });
            StructureData structureData = new StructureData(defaultBiomes, structure.method_41616(), structure.method_42701());
            if (JigsawStructureUtil.isJigsawLikeStructure(structure)) {
                class_5434.class_11600 maxDistanceFromCenter = JigsawStructureUtil.getMaxDistanceFromCenterForStructure(structure);
                int horizontalMaxDistanceFromCenter = maxDistanceFromCenter.comp_4451();
                int verticalMaxDistanceFromCenter = maxDistanceFromCenter.comp_4452();
                int maxSize = JigsawStructureUtil.getSizeForStructure(structure);
                structureData.setJigsawData(new JigsawData(maxSize, horizontalMaxDistanceFromCenter, verticalMaxDistanceFromCenter));
            }
            if (structureId.equals("minecraft:shipwreck_beached")) {
                FlatnessCheckData flatnessCheckData = structureData.getFlatnessCheckData();
                flatnessCheckData.overrideGlobalFlatnessCheck(true);
                flatnessCheckData.enable(false);
            }
            if (structureId.equals("nova_structures:illager_camp") && (biomes2 = structureData.getBiomes()).contains("minecraft:river")) {
                biomes2.remove("minecraft:river");
            }
            structures.put(structureId, structureData);
        }
        return structures;
    }

    public static Map<String, StructureSetData> loadStructureSets() {
        class_7225.class_7874 registryManager = StructurifyRegistryManagerProvider.getRegistryManager();
        if (registryManager == null) {
            return Collections.emptyMap();
        }
        class_7225.class_7226 structureSetRegistry = registryManager.method_46762(class_7924.field_41248);
        TreeMap<String, StructureSetData> structureSets = new TreeMap<String, StructureSetData>();
        for (class_6880.class_6883 structureSetReference : structureSetRegistry.method_42017().toList()) {
            class_7059 structureSet = (class_7059)structureSetReference.comp_349();
            class_2960 structureSetId = structureSetReference.method_40237().method_29177();
            String structureSetStringId = structureSetId.toString();
            class_6874 structureSetPlacement = structureSet.comp_511();
            int salt = 0;
            float frequency = 0.0f;
            int spacing = 0;
            int separation = 0;
            if (structureSetPlacement instanceof StructurifyStructurePlacement) {
                StructurifyStructurePlacement structurePlacement = (StructurifyStructurePlacement)structureSetPlacement;
                salt = structurePlacement.structurify$getOriginalSalt();
                frequency = structurePlacement.structurify$getOriginalFrequency();
            }
            if (structureSetPlacement instanceof StructurifyRandomSpreadStructurePlacement) {
                StructurifyRandomSpreadStructurePlacement randomSpreadStructurePlacement = (StructurifyRandomSpreadStructurePlacement)structureSetPlacement;
                spacing = randomSpreadStructurePlacement.structurify$getOriginalSpacing();
                separation = randomSpreadStructurePlacement.structurify$getOriginalSeparation();
            }
            if (!(structureSet.comp_511() instanceof class_6874)) continue;
            structureSets.put(structureSetStringId, new StructureSetData(salt, frequency, spacing, separation));
        }
        return structureSets;
    }
}

