/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.debug;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.api.StructurifyChunkGenerator;
import com.faboslav.structurify.common.config.data.DebugData;
import com.faboslav.structurify.common.debug.renderer.BiomeCheckDebugRenderer;
import com.faboslav.structurify.common.debug.renderer.FlatnessCheckDebugRenderer;
import com.faboslav.structurify.common.debug.renderer.StructureOverlapDebugRenderer;
import com.faboslav.structurify.world.level.structure.StructureSectionClaim;
import com.faboslav.structurify.world.level.structure.checks.StructureOverlapCheck;
import com.faboslav.structurify.world.level.structure.checks.debug.StructureBiomeCheckOverview;
import com.faboslav.structurify.world.level.structure.checks.debug.StructureBiomeCheckSample;
import com.faboslav.structurify.world.level.structure.checks.debug.StructureFlatnessCheckOverview;
import com.faboslav.structurify.world.level.structure.checks.debug.StructureFlatnessCheckSample;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1132;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

public final class StructurifyDebugRenderer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(class_310 minecraft, class_4587 poseStack, @Nullable class_4597 bufferSource) {
        class_3218 serverLevel;
        class_638 level;
        class_1132 singlePlayerServer;
        DebugData debugData = Structurify.getConfig().getDebugData();
        if (!debugData.isEnabled()) {
            return;
        }
        DebugData.DebugMode debugMode = debugData.getDebugMode();
        if (bufferSource == null) {
            bufferSource = minecraft.method_22940().method_23000();
        }
        int chunkRadius = Math.max((singlePlayerServer = minecraft.method_1576()) == null ? 8 : singlePlayerServer.method_3760().method_14568(), 8);
        class_4184 camera = minecraft.field_1773.method_19418();
        class_243 cameraPosition = camera.method_19326();
        class_2338 cameraBlockPosition = class_2338.method_49638((class_2374)cameraPosition);
        double camX = cameraPosition.field_1352;
        double camY = cameraPosition.field_1351;
        double camZ = cameraPosition.field_1350;
        if (debugMode == DebugData.DebugMode.FLATNESS) {
            Map<Long, StructureFlatnessCheckOverview> structureFlatnessCheckOverviews;
            Map<Long, StructureFlatnessCheckOverview> map = structureFlatnessCheckOverviews = Structurify.getConfig().getDebugData().getStructureFlatnessCheckOverviews();
            synchronized (map) {
                for (StructureFlatnessCheckOverview structureFlatnessCheckOverview : structureFlatnessCheckOverviews.values().stream().filter(o -> StructurifyDebugRenderer.isWithinChunkRadius(cameraBlockPosition, o.structureBoundingBox().method_22874(), chunkRadius)).toList()) {
                    FlatnessCheckDebugRenderer.renderStructureFlatnessCheckOverview(structureFlatnessCheckOverview, minecraft, poseStack, bufferSource, camX, camY, camZ);
                }
            }
            Map<Long, Set<StructureFlatnessCheckSample>> structureFlatnessCheckSamples = Structurify.getConfig().getDebugData().getStructureFlatnessCheckSamples();
            Map<Long, Set<StructureFlatnessCheckSample>> map2 = structureFlatnessCheckSamples;
            synchronized (map2) {
                for (StructureFlatnessCheckSample structureFlatnessCheckSample : structureFlatnessCheckSamples.values().stream().flatMap(Collection::stream).filter(o -> StructurifyDebugRenderer.isWithinChunkRadius(cameraBlockPosition, o.x(), o.freeY(), o.z(), chunkRadius)).toList()) {
                    FlatnessCheckDebugRenderer.renderStructureFlatnessCheckSample(structureFlatnessCheckSample, poseStack, bufferSource, camX, camY, camZ);
                }
            }
        }
        if (debugMode == DebugData.DebugMode.BIOME) {
            Map<Long, StructureBiomeCheckOverview> structureBiomeCheckOverviews;
            Map<Long, StructureBiomeCheckOverview> structureFlatnessCheckSamples = structureBiomeCheckOverviews = Structurify.getConfig().getDebugData().getStructureBiomeCheckOverviews();
            synchronized (structureFlatnessCheckSamples) {
                for (StructureBiomeCheckOverview structureBiomeCheckOverview : structureBiomeCheckOverviews.values().stream().filter(o -> StructurifyDebugRenderer.isWithinChunkRadius(cameraBlockPosition, o.structureBoundingBox().method_22874(), chunkRadius)).toList()) {
                    BiomeCheckDebugRenderer.renderStructureBiomeCheckOverview(structureBiomeCheckOverview, minecraft, poseStack, bufferSource, camX, camY, camZ);
                }
            }
            Map<Long, Set<StructureBiomeCheckSample>> structureBiomeCheckSamples = Structurify.getConfig().getDebugData().getStructureBiomeCheckSamples();
            Map<Long, Set<StructureBiomeCheckSample>> map = structureBiomeCheckSamples;
            synchronized (map) {
                for (StructureBiomeCheckSample structureBiomeCheckSample : structureBiomeCheckSamples.values().stream().flatMap(Collection::stream).filter(o -> StructurifyDebugRenderer.isWithinChunkRadius(cameraBlockPosition, o.x(), o.y(), o.z(), chunkRadius)).toList()) {
                    BiomeCheckDebugRenderer.renderStructureBiomeCheckSample(structureBiomeCheckSample, poseStack, bufferSource, camX, camY, camZ);
                }
            }
        }
        if (debugMode == DebugData.DebugMode.OVERLAP && (level = minecraft.field_1687) != null && minecraft.method_1576() != null && (serverLevel = minecraft.method_1576().method_3847(level.method_27983())) != null) {
            Map<Long, StructureSectionClaim> map;
            StructurifyChunkGenerator chunkGenerator = (StructurifyChunkGenerator)serverLevel.method_14178().method_12129();
            Map<Long, StructureSectionClaim> map2 = map = chunkGenerator.structurify$getStructureSectionClaims();
            synchronized (map2) {
                for (Map.Entry<Long, StructureSectionClaim> entry : map.entrySet()) {
                    Long key = entry.getKey();
                    StructureSectionClaim structureSectionClaim = entry.getValue();
                    class_2338 pos = StructureOverlapCheck.unpackCell(key, 8, 8, 8);
                    if (!StructurifyDebugRenderer.isWithinChunkRadius(cameraBlockPosition, pos.method_10263(), pos.method_10264(), pos.method_10260(), chunkRadius)) continue;
                    StructureOverlapDebugRenderer.renderStructureSectionClaim(structureSectionClaim, minecraft, poseStack, bufferSource, pos, camX, camY, camZ);
                }
            }
        }
    }

    private static boolean isWithinChunkRadius(class_2338 cameraBlockPos, class_2338 targetBlockPos, int chunkRadius) {
        int camChunkX = class_4076.method_18675((int)cameraBlockPos.method_10263());
        int camChunkZ = class_4076.method_18675((int)cameraBlockPos.method_10260());
        int tgtChunkX = class_4076.method_18675((int)targetBlockPos.method_10263());
        int tgtChunkZ = class_4076.method_18675((int)targetBlockPos.method_10260());
        return Math.max(Math.abs(tgtChunkX - camChunkX), Math.abs(tgtChunkZ - camChunkZ)) <= chunkRadius;
    }

    private static boolean isWithinChunkRadius(class_2338 cameraBlockPos, int targetX, int targetY, int targetZ, int chunkRadius) {
        return StructurifyDebugRenderer.isWithinChunkRadius(cameraBlockPos, new class_2338(targetX, targetY, targetZ), chunkRadius);
    }
}

