/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.config.data.DebugData;
import com.faboslav.structurify.common.config.data.StructureData;
import com.faboslav.structurify.common.config.data.StructureNamespaceData;
import com.faboslav.structurify.common.config.data.StructureSetData;
import com.faboslav.structurify.common.config.data.WorldgenDataProvider;
import com.faboslav.structurify.common.config.serialization.StructureDataSerializer;
import com.faboslav.structurify.common.config.serialization.StructureNamespaceDataSerializer;
import com.faboslav.structurify.common.config.serialization.StructureSetDataSerializer;
import com.faboslav.structurify.common.events.common.UpdateRegistriesEvent;
import com.faboslav.structurify.common.platform.PlatformHooks;
import com.faboslav.structurify.common.registry.StructurifyRegistryManagerProvider;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

public final class StructurifyConfig {
    private static final Path BACKUP_CONFIG_DIR = Path.of("config/structurify", new String[0]);
    private static final String BACKUP_PREFIX = "structurify_backup_";
    private static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss");
    public boolean isLoaded = false;
    public boolean isLoading = false;
    private final Path configPath = Path.of("config", "structurify.json");
    public final Path configDumpPath = Path.of("config", "structurify_dump.json");
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public boolean disableAllStructures = false;
    public boolean preventStructureOverlap = false;
    public boolean enableGlobalSpacingAndSeparationModifier = false;
    public double globalSpacingAndSeparationModifier = 1.0;
    private final DebugData debugData = new DebugData();
    private Map<String, StructureNamespaceData> structureNamespaceData = new TreeMap<String, StructureNamespaceData>();
    private Map<String, StructureData> structureData = new TreeMap<String, StructureData>();
    private Map<String, StructureSetData> structureSetData = new TreeMap<String, StructureSetData>();
    public static final boolean ENABLE_GLOBAL_SPACING_AND_SEPARATION_MODIFIER_DEFAULT_VALUE = false;
    public static final double GLOBAL_SPACING_AND_SEPARATION_MODIFIER_DEFAULT_VALUE = 1.0;
    private static final String CONFIG_VERSION_PROPERTY = "config_version";
    private static final String CONFIG_DATETIME_PROPERTY = "config_datetime";
    private static final String GENERAL_PROPERTY = "general";
    private static final String DISABLE_ALL_STRUCTURES_PROPERTY = "disable_all_structures";
    private static final String PREVENT_STRUCTURE_OVERLAP_PROPERTY = "prevent_structure_overlap";
    private static final String ENABLE_GLOBAL_SPACING_AND_SEPARATION_MODIFIER_PROPERTY = "enable_global_spacing_and_separation_modifier";
    private static final String GLOBAL_SPACING_AND_SEPARATION_MODIFIER_PROPERTY = "global_spacing_and_separation_modifier";
    private static final String STRUCTURES_PROPERTY = "structures";
    private static final String STRUCTURE_NAMESPACES_PROPERTY = "structure_namespaces";
    private static final String STRUCTURE_SETS_PROPERTY = "structure_sets";

    public Map<String, StructureNamespaceData> getStructureNamespaceData() {
        return this.structureNamespaceData;
    }

    public Map<String, StructureData> getStructureData() {
        return this.structureData;
    }

    public Map<String, StructureSetData> getStructureSetData() {
        return this.structureSetData;
    }

    public DebugData getDebugData() {
        return this.debugData;
    }

    public void create() {
        if (Files.exists(this.configPath, new LinkOption[0])) {
            return;
        }
        this.save();
    }

    public void load() {
        if (this.isLoading) {
            return;
        }
        try {
            Structurify.getLogger().info("Loading Structurify config...");
            this.isLoading = true;
            WorldgenDataProvider.loadWorldgenData();
            this.structureNamespaceData = WorldgenDataProvider.getStructureNamespaces();
            this.structureData = WorldgenDataProvider.getStructures();
            this.structureSetData = WorldgenDataProvider.getStructureSets();
            if (!Files.exists(this.configPath, new LinkOption[0])) {
                return;
            }
            String jsonString = Files.readString(this.configPath);
            JsonObject json = (JsonObject)this.gson.fromJson(jsonString, JsonObject.class);
            this.loadGeneral(json);
            this.loadStructureNamespaces(json);
            this.loadStructures(json);
            this.loadStructureSets(json);
            Structurify.getLogger().info("Structurify config loaded");
            this.isLoaded = true;
        }
        catch (Exception e) {
            Structurify.getLogger().error("Failed to load Structurify config");
            e.printStackTrace();
        }
        finally {
            this.isLoading = false;
        }
    }

    private void loadGeneral(JsonObject json) {
        if (!json.has(GENERAL_PROPERTY)) {
            return;
        }
        JsonObject general = json.getAsJsonObject(GENERAL_PROPERTY);
        if (general.has(DISABLE_ALL_STRUCTURES_PROPERTY)) {
            this.disableAllStructures = general.get(DISABLE_ALL_STRUCTURES_PROPERTY).getAsBoolean();
        }
        if (general.has(PREVENT_STRUCTURE_OVERLAP_PROPERTY)) {
            this.preventStructureOverlap = general.get(PREVENT_STRUCTURE_OVERLAP_PROPERTY).getAsBoolean();
        }
        if (general.has(ENABLE_GLOBAL_SPACING_AND_SEPARATION_MODIFIER_PROPERTY)) {
            this.enableGlobalSpacingAndSeparationModifier = general.get(ENABLE_GLOBAL_SPACING_AND_SEPARATION_MODIFIER_PROPERTY).getAsBoolean();
        }
        if (general.has(GLOBAL_SPACING_AND_SEPARATION_MODIFIER_PROPERTY)) {
            this.globalSpacingAndSeparationModifier = (double)Math.round(general.get(GLOBAL_SPACING_AND_SEPARATION_MODIFIER_PROPERTY).getAsDouble() * 10.0) / 10.0;
        }
    }

    private void loadStructureNamespaces(JsonObject json) {
        if (!json.has(STRUCTURE_NAMESPACES_PROPERTY)) {
            return;
        }
        JsonArray structureNamespaces = json.getAsJsonArray(STRUCTURE_NAMESPACES_PROPERTY);
        for (JsonElement structureNamespace : structureNamespaces) {
            JsonObject structureNamespaceJson = structureNamespace.getAsJsonObject();
            if (!structureNamespaceJson.has("name")) {
                Structurify.getLogger().info("Found invalid structure namespace entry, skipping.");
                continue;
            }
            if (!this.structureNamespaceData.containsKey(structureNamespaceJson.get("name").getAsString())) {
                Structurify.getLogger().info("Found invalid structure namespace identifier of \"{}\", skipping.", (Object)structureNamespaceJson.get("name").getAsString());
                continue;
            }
            StructureNamespaceData structureNamespaceData = this.structureNamespaceData.get(structureNamespaceJson.get("name").getAsString());
            if (structureNamespaceData == null) continue;
            StructureNamespaceDataSerializer.load(structureNamespaceJson, structureNamespaceData);
        }
    }

    private void loadStructures(JsonObject json) {
        if (!json.has(STRUCTURES_PROPERTY)) {
            return;
        }
        JsonArray structures = json.getAsJsonArray(STRUCTURES_PROPERTY);
        for (JsonElement structure : structures) {
            JsonObject structureJson = structure.getAsJsonObject();
            if (!structureJson.has("name")) {
                Structurify.getLogger().info("Found invalid structure entry, skipping.");
                continue;
            }
            if (!this.structureData.containsKey(structureJson.get("name").getAsString())) {
                Structurify.getLogger().info("Found invalid structure identifier of \"{}\", skipping.", (Object)structureJson.get("name").getAsString());
                continue;
            }
            StructureData structureData = this.structureData.get(structureJson.get("name").getAsString());
            if (structureData == null) continue;
            StructureDataSerializer.load(structureJson, structureData);
        }
    }

    private void loadStructureSets(JsonObject json) {
        if (!json.has(STRUCTURE_SETS_PROPERTY)) {
            return;
        }
        JsonArray structureSets = json.getAsJsonArray(STRUCTURE_SETS_PROPERTY);
        for (JsonElement structureSet : structureSets) {
            JsonObject structureSetJson = structureSet.getAsJsonObject();
            if (!structureSetJson.has("name")) {
                Structurify.getLogger().info("Found invalid structure set entry, skipping.");
                continue;
            }
            String structureSetName = structureSetJson.get("name").getAsString();
            if (!this.structureSetData.containsKey(structureSetName)) {
                Structurify.getLogger().info("Found invalid structure set identifier of \"{}\", skipping.", (Object)structureSetName);
                continue;
            }
            StructureSetData structureSetData = this.structureSetData.get(structureSetName);
            StructureSetDataSerializer.load(structureSetJson, structureSetData);
        }
    }

    public void save() {
        Structurify.getLogger().info("Saving Structurify config...");
        try {
            if (Files.exists(this.configPath, new LinkOption[0])) {
                Path backupConfigPath = this.getBackupConfigPath();
                if (!Files.exists(BACKUP_CONFIG_DIR, new LinkOption[0]) || !Files.isDirectory(BACKUP_CONFIG_DIR, new LinkOption[0])) {
                    Files.createDirectories(BACKUP_CONFIG_DIR, new FileAttribute[0]);
                }
                if (!Files.exists(backupConfigPath, new LinkOption[0])) {
                    Files.move(this.configPath, backupConfigPath, new CopyOption[0]);
                }
            }
            JsonObject json = new JsonObject();
            json.addProperty(CONFIG_VERSION_PROPERTY, PlatformHooks.PLATFORM_HELPER.getModVersion());
            json.addProperty(CONFIG_DATETIME_PROPERTY, LocalDateTime.now().format(DATETIME_FORMATTER));
            this.saveGeneralData(json);
            this.saveStructureNamespacesData(json, true);
            this.saveStructuresData(json, true);
            this.saveStructureSetsData(json, true);
            Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
            Files.createFile(this.configPath, new FileAttribute[0]);
            Files.writeString(this.configPath, (CharSequence)this.gson.toJson((JsonElement)json), new OpenOption[0]);
            Structurify.getLogger().info("Structurify config saved");
            Structurify.getLogger().info("Syncing changes to registries...");
            UpdateRegistriesEvent.EVENT.invoke(new UpdateRegistriesEvent(StructurifyRegistryManagerProvider.getRegistryManager()));
            Structurify.getLogger().info("Registries synced");
        }
        catch (Exception e) {
            Structurify.getLogger().error("Failed to save Structurify config");
            e.printStackTrace();
            try {
                Path possibleLatestBackupConfigPath = this.getLatestBackupConfigPath();
                if (possibleLatestBackupConfigPath != null) {
                    Structurify.getLogger().error("Restoring Structurify backup config...");
                    if (Files.exists(this.configPath, new LinkOption[0])) {
                        Files.delete(this.configPath);
                    }
                    Files.move(possibleLatestBackupConfigPath, this.configPath, new CopyOption[0]);
                }
            }
            catch (Exception fe) {
                Structurify.getLogger().error("Failed to restore Structurify backup config");
                fe.printStackTrace();
            }
        }
    }

    public void dump() {
        Structurify.getLogger().info("Dumping Structurify config...");
        try {
            if (Files.exists(this.configDumpPath, new LinkOption[0])) {
                Files.delete(this.configDumpPath);
            }
            JsonObject json = new JsonObject();
            json.addProperty(CONFIG_VERSION_PROPERTY, PlatformHooks.PLATFORM_HELPER.getModVersion());
            json.addProperty(CONFIG_DATETIME_PROPERTY, LocalDateTime.now().format(DATETIME_FORMATTER));
            this.saveGeneralData(json);
            this.saveStructureNamespacesData(json, false);
            this.saveStructuresData(json, false);
            this.saveStructureSetsData(json, false);
            Files.createDirectories(this.configDumpPath.getParent(), new FileAttribute[0]);
            Files.createFile(this.configDumpPath, new FileAttribute[0]);
            Files.writeString(this.configDumpPath, (CharSequence)this.gson.toJson((JsonElement)json), new OpenOption[0]);
            Structurify.getLogger().info("Structurify config successfully dumped");
        }
        catch (Exception e) {
            Structurify.getLogger().error("Failed to dump Structurify config");
            e.printStackTrace();
        }
    }

    private void saveGeneralData(JsonObject json) {
        JsonObject general = new JsonObject();
        general.addProperty(DISABLE_ALL_STRUCTURES_PROPERTY, Boolean.valueOf(this.disableAllStructures));
        general.addProperty(PREVENT_STRUCTURE_OVERLAP_PROPERTY, Boolean.valueOf(this.preventStructureOverlap));
        general.addProperty(ENABLE_GLOBAL_SPACING_AND_SEPARATION_MODIFIER_PROPERTY, Boolean.valueOf(this.enableGlobalSpacingAndSeparationModifier));
        general.addProperty(GLOBAL_SPACING_AND_SEPARATION_MODIFIER_PROPERTY, (Number)((double)Math.round(this.globalSpacingAndSeparationModifier * 10.0) / 10.0));
        json.add(GENERAL_PROPERTY, (JsonElement)general);
    }

    private void saveStructureNamespacesData(JsonObject json, boolean saveOnlyChanged) {
        JsonArray structureNamespaces = new JsonArray();
        this.structureNamespaceData.entrySet().stream().filter(entry -> !saveOnlyChanged || !((StructureNamespaceData)entry.getValue()).isUsingDefaultValues()).forEach(structureNamespaceDataEntry -> StructureNamespaceDataSerializer.save(structureNamespaces, (String)structureNamespaceDataEntry.getKey(), (StructureNamespaceData)structureNamespaceDataEntry.getValue()));
        json.add(STRUCTURE_NAMESPACES_PROPERTY, (JsonElement)structureNamespaces);
    }

    private void saveStructuresData(JsonObject json, boolean saveOnlyChanged) {
        JsonArray structures = new JsonArray();
        this.structureData.entrySet().stream().filter(entry -> !saveOnlyChanged || !((StructureData)entry.getValue()).isUsingDefaultValues()).forEach(structureDataEntry -> StructureDataSerializer.save(structures, (String)structureDataEntry.getKey(), (StructureData)structureDataEntry.getValue()));
        json.add(STRUCTURES_PROPERTY, (JsonElement)structures);
    }

    private void saveStructureSetsData(JsonObject json, boolean saveOnlyChanged) {
        JsonArray structureSets = new JsonArray();
        HashMap structureSetSalts = new HashMap();
        this.structureSetData.entrySet().stream().filter(entry -> !saveOnlyChanged || ((StructureSetData)entry.getValue()).isUsingDefaultValues()).forEach(structureSetDataEntry -> {
            String structureSetName = (String)structureSetDataEntry.getKey();
            StructureSetData structureSetData = (StructureSetData)structureSetDataEntry.getValue();
            int salt = structureSetData.getSalt();
            if (structureSetSalts.containsKey(salt)) {
                Structurify.getLogger().warn("Salt value for structure set {} is currently {}, which is already being used by {} structure set.", new Object[]{structureSetName, salt, structureSetSalts.get(salt)});
            } else {
                structureSetSalts.put(structureSetData.getSalt(), structureSetName);
            }
            StructureSetDataSerializer.save(structureSets, structureSetName, structureSetData);
        });
        json.add(STRUCTURE_SETS_PROPERTY, (JsonElement)structureSets);
    }

    private Path getBackupConfigPath() {
        String dateTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss"));
        return Path.of(BACKUP_CONFIG_DIR.toString(), BACKUP_PREFIX + dateTime + ".json");
    }

    private Path getLatestBackupConfigPath() {
        try {
            if (!Files.exists(BACKUP_CONFIG_DIR, new LinkOption[0]) || !Files.isDirectory(BACKUP_CONFIG_DIR, new LinkOption[0])) {
                return null;
            }
            Optional<Path> latest = Files.list(BACKUP_CONFIG_DIR).filter(path -> path.getFileName().toString().startsWith(BACKUP_PREFIX) && path.toString().endsWith(".json")).max(Comparator.comparing(path -> {
                String timestamp = path.getFileName().toString().replace(BACKUP_PREFIX, "").replace(".json", "");
                try {
                    return LocalDateTime.parse(timestamp, DATETIME_FORMATTER);
                }
                catch (Exception e) {
                    return LocalDateTime.MIN;
                }
            }));
            return latest.orElse(null);
        }
        catch (IOException e) {
            Structurify.getLogger().error("Failed to load Structurify backup configs");
            e.printStackTrace();
            return null;
        }
    }
}

