/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.debug;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.api.StructurifyChunkGenerator;
import com.faboslav.structurify.common.config.data.DebugData;
import com.faboslav.structurify.common.debug.renderer.BiomeCheckDebugRenderer;
import com.faboslav.structurify.common.debug.renderer.FlatnessCheckDebugRenderer;
import com.faboslav.structurify.common.debug.renderer.StructureOverlapDebugRenderer;
import com.faboslav.structurify.world.level.structure.StructureSectionClaim;
import com.faboslav.structurify.world.level.structure.checks.debug.StructureBiomeCheckOverview;
import com.faboslav.structurify.world.level.structure.checks.debug.StructureBiomeCheckSample;
import com.faboslav.structurify.world.level.structure.checks.debug.StructureFlatnessCheckOverview;
import com.faboslav.structurify.world.level.structure.checks.debug.StructureFlatnessCheckSample;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class StructurifyDebugRenderer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Minecraft minecraft, PoseStack poseStack, @Nullable MultiBufferSource bufferSource) {
        ServerLevel serverLevel;
        ClientLevel level;
        IntegratedServer singlePlayerServer;
        DebugData debugData = Structurify.getConfig().getDebugData();
        if (!debugData.isEnabled()) {
            return;
        }
        DebugData.DebugMode debugMode = debugData.getDebugMode();
        if (bufferSource == null) {
            bufferSource = minecraft.renderBuffers().bufferSource();
        }
        int chunkRadius = Math.max((singlePlayerServer = minecraft.getSingleplayerServer()) == null ? 8 : singlePlayerServer.getPlayerList().getViewDistance(), 8);
        Camera camera = minecraft.gameRenderer.getMainCamera();
        Vec3 cameraPosition = camera.getPosition();
        BlockPos cameraBlockPosition = BlockPos.containing((Position)cameraPosition);
        double camX = cameraPosition.x;
        double camY = cameraPosition.y;
        double camZ = cameraPosition.z;
        if (debugMode == DebugData.DebugMode.FLATNESS) {
            Map<Long, StructureFlatnessCheckOverview> structureFlatnessCheckOverviews;
            Map<Long, StructureFlatnessCheckOverview> map = structureFlatnessCheckOverviews = Structurify.getConfig().getDebugData().getStructureFlatnessCheckOverviews();
            synchronized (map) {
                for (StructureFlatnessCheckOverview structureFlatnessCheckOverview : structureFlatnessCheckOverviews.values().stream().filter(o -> StructurifyDebugRenderer.isWithinChunkRadius(cameraBlockPosition, o.structureBoundingBox().getCenter(), chunkRadius)).toList()) {
                    FlatnessCheckDebugRenderer.renderStructureFlatnessCheckOverview(structureFlatnessCheckOverview, minecraft, poseStack, bufferSource, camX, camY, camZ);
                }
            }
            Map<Long, Set<StructureFlatnessCheckSample>> structureFlatnessCheckSamples = Structurify.getConfig().getDebugData().getStructureFlatnessCheckSamples();
            Map<Long, Set<StructureFlatnessCheckSample>> map2 = structureFlatnessCheckSamples;
            synchronized (map2) {
                for (StructureFlatnessCheckSample structureFlatnessCheckSample : structureFlatnessCheckSamples.values().stream().flatMap(Collection::stream).filter(o -> StructurifyDebugRenderer.isWithinChunkRadius(cameraBlockPosition, o.x(), o.freeY(), o.z(), chunkRadius)).toList()) {
                    FlatnessCheckDebugRenderer.renderStructureFlatnessCheckSample(structureFlatnessCheckSample, poseStack, bufferSource, camX, camY, camZ);
                }
            }
        }
        if (debugMode == DebugData.DebugMode.BIOME) {
            Map<Long, StructureBiomeCheckOverview> structureBiomeCheckOverviews;
            Map<Long, StructureBiomeCheckOverview> structureFlatnessCheckSamples = structureBiomeCheckOverviews = Structurify.getConfig().getDebugData().getStructureBiomeCheckOverviews();
            synchronized (structureFlatnessCheckSamples) {
                for (StructureBiomeCheckOverview structureBiomeCheckOverview : structureBiomeCheckOverviews.values().stream().filter(o -> StructurifyDebugRenderer.isWithinChunkRadius(cameraBlockPosition, o.structureBoundingBox().getCenter(), chunkRadius)).toList()) {
                    BiomeCheckDebugRenderer.renderStructureBiomeCheckOverview(structureBiomeCheckOverview, minecraft, poseStack, bufferSource, camX, camY, camZ);
                }
            }
            Map<Long, Set<StructureBiomeCheckSample>> structureBiomeCheckSamples = Structurify.getConfig().getDebugData().getStructureBiomeCheckSamples();
            Map<Long, Set<StructureBiomeCheckSample>> map = structureBiomeCheckSamples;
            synchronized (map) {
                for (StructureBiomeCheckSample structureBiomeCheckSample : structureBiomeCheckSamples.values().stream().flatMap(Collection::stream).filter(o -> StructurifyDebugRenderer.isWithinChunkRadius(cameraBlockPosition, o.x(), o.y(), o.z(), chunkRadius)).toList()) {
                    BiomeCheckDebugRenderer.renderStructureBiomeCheckSample(structureBiomeCheckSample, poseStack, bufferSource, camX, camY, camZ);
                }
            }
        }
        if (debugMode == DebugData.DebugMode.OVERLAP && (level = minecraft.level) != null && minecraft.getSingleplayerServer() != null && (serverLevel = minecraft.getSingleplayerServer().getLevel(level.dimension())) != null) {
            Map<Long, StructureSectionClaim> map;
            StructurifyChunkGenerator chunkGenerator = (StructurifyChunkGenerator)serverLevel.getChunkSource().getGenerator();
            Map<Long, StructureSectionClaim> map2 = map = chunkGenerator.structurify$getStructureSectionClaims();
            synchronized (map2) {
                for (Map.Entry<Long, StructureSectionClaim> entry : map.entrySet()) {
                    Long sectionKey = entry.getKey();
                    StructureSectionClaim structureSectionClaim = entry.getValue();
                    SectionPos sectionPos = SectionPos.of((long)sectionKey);
                    BlockPos pos = sectionPos.origin();
                    if (!StructurifyDebugRenderer.isWithinChunkRadius(cameraBlockPosition, pos.getX(), pos.getY(), pos.getZ(), chunkRadius)) continue;
                    StructureOverlapDebugRenderer.renderStructureSectionClaim(structureSectionClaim, minecraft, poseStack, bufferSource, pos, camX, camY, camZ);
                }
            }
        }
    }

    private static boolean isWithinChunkRadius(BlockPos cameraBlockPos, BlockPos targetBlockPos, int chunkRadius) {
        int camChunkX = SectionPos.blockToSectionCoord((int)cameraBlockPos.getX());
        int camChunkZ = SectionPos.blockToSectionCoord((int)cameraBlockPos.getZ());
        int tgtChunkX = SectionPos.blockToSectionCoord((int)targetBlockPos.getX());
        int tgtChunkZ = SectionPos.blockToSectionCoord((int)targetBlockPos.getZ());
        return Math.max(Math.abs(tgtChunkX - camChunkX), Math.abs(tgtChunkZ - camChunkZ)) <= chunkRadius;
    }

    private static boolean isWithinChunkRadius(BlockPos cameraBlockPos, int targetX, int targetY, int targetZ, int chunkRadius) {
        return StructurifyDebugRenderer.isWithinChunkRadius(cameraBlockPos, new BlockPos(targetX, targetY, targetZ), chunkRadius);
    }
}

