/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.mixin.structure;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.api.StructurifyStructure;
import com.faboslav.structurify.common.config.data.StructureData;
import com.faboslav.structurify.common.config.data.StructureNamespaceData;
import com.faboslav.structurify.common.util.BiomeUtil;
import com.faboslav.structurify.world.level.structure.checks.StructureChecker;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Structure.class})
public abstract class StructureMixin
implements StructurifyStructure {
    @Unique
    @Nullable
    public ResourceLocation structurify$structureIdentifier = null;
    @Unique
    @Nullable
    private StructureNamespaceData structurify$globalStructureNamespaceData = null;
    @Unique
    @Nullable
    private StructureNamespaceData structurify$structureNamespaceData = null;
    @Unique
    @Nullable
    private StructureData structurify$structureData = null;
    @Unique
    @Nullable
    public HolderSet<Biome> structurify$structureBiomes = null;
    @Unique
    @Nullable
    public HolderSet<Biome> structurify$structureBlacklistedBiomes = null;

    @Override
    public void structurify$setStructureIdentifier(ResourceLocation structureSetIdentifier) {
        this.structurify$structureIdentifier = structureSetIdentifier;
        this.structurify$globalStructureNamespaceData = null;
        this.structurify$structureNamespaceData = null;
        this.structurify$structureData = null;
    }

    @Override
    @Nullable
    public ResourceLocation structurify$getStructureIdentifier() {
        return this.structurify$structureIdentifier;
    }

    @Override
    @Unique
    public StructureNamespaceData structurify$getGlobalStructureNamespaceData() {
        if (this.structurify$globalStructureNamespaceData == null) {
            this.structurify$globalStructureNamespaceData = Structurify.getConfig().getStructureNamespaceData().get(StructureNamespaceData.GLOBAL_NAMESPACE_IDENTIFIER);
        }
        return this.structurify$globalStructureNamespaceData;
    }

    @Override
    @Unique
    @Nullable
    public StructureNamespaceData structurify$getStructureNamespaceData() {
        return this.structurify$getStructureNamespaceData(this.structurify$getStructureIdentifier());
    }

    @Override
    @Unique
    @Nullable
    public StructureNamespaceData structurify$getStructureNamespaceData(@Nullable ResourceLocation structureIdentifier) {
        if (this.structurify$structureNamespaceData == null) {
            if (structureIdentifier == null) {
                structureIdentifier = this.structurify$getStructureIdentifier();
            }
            if (structureIdentifier != null) {
                this.structurify$structureNamespaceData = Structurify.getConfig().getStructureNamespaceData().get(structureIdentifier.getNamespace());
            }
        }
        return this.structurify$structureNamespaceData;
    }

    @Override
    @Unique
    @Nullable
    public StructureData structurify$getStructureData() {
        ResourceLocation structureIdentifier;
        if (this.structurify$structureData == null && (structureIdentifier = this.structurify$getStructureIdentifier()) != null) {
            this.structurify$structureData = Structurify.getConfig().getStructureData().get(structureIdentifier.toString());
        }
        return this.structurify$structureData;
    }

    @Override
    @Unique
    @Nullable
    public StructureData structurify$getStructureData(@Nullable ResourceLocation structureIdentifier) {
        if (this.structurify$structureData == null) {
            if (structureIdentifier == null) {
                structureIdentifier = this.structurify$getStructureIdentifier();
            }
            if (structureIdentifier != null) {
                this.structurify$structureData = Structurify.getConfig().getStructureData().get(structureIdentifier.toString());
            }
        }
        return this.structurify$structureData;
    }

    @Override
    public void structurify$setStructureBiomes(@Nullable HolderSet<Biome> biomeHolderSet) {
        this.structurify$structureBiomes = biomeHolderSet;
    }

    @Override
    @Nullable
    public HolderSet<Biome> structurify$getStructureBiomes() {
        return this.structurify$structureBiomes;
    }

    @Override
    public void structurify$setStructureBlacklistedBiomes(@Nullable HolderSet<Biome> biomeHolderSet) {
        this.structurify$structureBlacklistedBiomes = biomeHolderSet;
    }

    @Override
    @Nullable
    public HolderSet<Biome> structurify$getStructureBlacklistedBiomes() {
        if (this.structurify$structureBlacklistedBiomes == null) {
            HolderSet<Biome> blacklistedBiomeHolderSet = BiomeUtil.getBlacklistedBiomes(this.structurify$getStructureIdentifier());
            this.structurify$setStructureBlacklistedBiomes(blacklistedBiomeHolderSet);
        }
        return this.structurify$structureBlacklistedBiomes;
    }

    @WrapMethod(method={"biomes"})
    private HolderSet<Biome> structurify$biomes(Operation<HolderSet<Biome>> original) {
        if (this.structurify$structureBiomes == null) {
            HolderSet<Biome> biomeHolderSet = BiomeUtil.getBiomes(this.structurify$getStructureIdentifier(), (HolderSet<Biome>)((HolderSet)original.call(new Object[0])));
            this.structurify$setStructureBiomes(biomeHolderSet);
        }
        return this.structurify$getStructureBiomes();
    }

    @WrapMethod(method={"step"})
    private GenerationStep.Decoration structurify$step(Operation<GenerationStep.Decoration> original) {
        StructureData structureData = this.structurify$getStructureData();
        if (structureData == null) {
            return (GenerationStep.Decoration)original.call(new Object[0]);
        }
        return structureData.getStep();
    }

    @WrapMethod(method={"terrainAdaptation"})
    private TerrainAdjustment structurify$terrainAdaptation(Operation<TerrainAdjustment> original) {
        StructureData structureData = this.structurify$getStructureData();
        if (structureData == null) {
            return (TerrainAdjustment)original.call(new Object[0]);
        }
        return structureData.getTerrainAdaptation();
    }

    @WrapMethod(method={"generate"})
    private StructureStart structurify$generate(RegistryAccess registryAccess, ChunkGenerator chunkGenerator, BiomeSource biomeSource, RandomState randomState, StructureTemplateManager structureTemplateManager, long seed, ChunkPos chunkPos, int references, LevelHeightAccessor heightAccessor, Predicate<Holder<Biome>> validBiome, Operation<StructureStart> original) {
        StructureStart structureStart = (StructureStart)original.call(new Object[]{registryAccess, chunkGenerator, biomeSource, randomState, structureTemplateManager, seed, chunkPos, references, heightAccessor, validBiome});
        ResourceLocation structureId = null;
        structureId = this.structurify$getStructureIdentifier();
        if (structureStart == StructureStart.INVALID_START || !structureStart.isValid()) {
            return structureStart;
        }
        boolean structureCheckResult = StructureChecker.checkStructure(structureStart, structureId, this, chunkGenerator, heightAccessor, randomState, biomeSource);
        if (!structureCheckResult) {
            return StructureStart.INVALID_START;
        }
        return structureStart;
    }
}

