/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.commands;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.api.StructurifyStructure;
import com.faboslav.structurify.common.config.data.DebugData;
import com.faboslav.structurify.common.mixin.LocateCommandInvoker;
import com.faboslav.structurify.world.level.structure.checks.StructureChecker;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Pair;
import java.time.Duration;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.commands.LocateCommand;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public final class StructurifyCommand {
    private static final SuggestionProvider<CommandSourceStack> DEBUG_MODE_SUGGESTIONS = (ctx, builder) -> SharedSuggestionProvider.suggest(DebugData.DebugMode.getNames(), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> SAMPLING_MODE_SUGGESTIONS = (ctx, builder) -> SharedSuggestionProvider.suggest(DebugData.SamplingMode.getNames(), (SuggestionsBuilder)builder);

    public static void createCommand(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"structurify").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"dump").executes(ctx -> {
            Structurify.getConfig().dump();
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Structurify config dumped to \"" + String.valueOf(Structurify.getConfig().configDumpPath) + "\".")), !((CommandSourceStack)ctx.getSource()).isPlayer());
            return 1;
        }))).then(Commands.literal((String)"locate").then(Commands.literal((String)"structure").then(Commands.argument((String)"structure", (ArgumentType)ResourceOrTagKeyArgument.resourceOrTagKey((ResourceKey)Registries.STRUCTURE)).executes(commandContext -> StructurifyCommand.locateStructure((CommandSourceStack)commandContext.getSource(), (ResourceOrTagKeyArgument.Result<Structure>)ResourceOrTagKeyArgument.getResourceOrTagKey((CommandContext)commandContext, (String)"structure", (ResourceKey)Registries.STRUCTURE, (DynamicCommandExceptionType)LocateCommandInvoker.structurify$getStructureInvalidError()))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"debug").then(((LiteralArgumentBuilder)Commands.literal((String)"enable").requires(src -> src.hasPermission(2))).executes(ctx -> {
            Structurify.getConfig().getDebugData().setEnabled(true);
            Structurify.getConfig().getDebugData().setDebugMode(DebugData.DebugMode.FLATNESS);
            Structurify.getConfig().getDebugData().setSamplingMode(DebugData.SamplingMode.FINAL);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Structurify debug enabled."), !((CommandSourceStack)ctx.getSource()).isPlayer());
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"disable").requires(src -> src.hasPermission(2))).executes(ctx -> {
            Structurify.getConfig().getDebugData().setEnabled(false);
            Structurify.getConfig().getDebugData().setDebugMode(DebugData.DebugMode.NONE);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Structurify debug disabled."), !((CommandSourceStack)ctx.getSource()).isPlayer());
            return 1;
        }))).then(Commands.literal((String)"debug_mode").then(((RequiredArgumentBuilder)Commands.argument((String)"debugMode", (ArgumentType)StringArgumentType.word()).suggests(DEBUG_MODE_SUGGESTIONS).requires(src -> src.hasPermission(2))).executes(ctx -> {
            DebugData.DebugMode debugMode;
            String raw = StringArgumentType.getString((CommandContext)ctx, (String)"debugMode");
            try {
                debugMode = DebugData.DebugMode.valueOf(raw.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException ex) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("Unknown debug mode: " + raw)));
                return 0;
            }
            Structurify.getConfig().getDebugData().setEnabled(true);
            Structurify.getConfig().getDebugData().setDebugMode(debugMode);
            StructurifyCommand.reloadStructureChecks((CommandContext<CommandSourceStack>)ctx);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Structurify debug mode changed to " + String.valueOf((Object)debugMode) + ".")), !((CommandSourceStack)ctx.getSource()).isPlayer());
            return 1;
        })))).then(Commands.literal((String)"sampling_mode").then(((RequiredArgumentBuilder)Commands.argument((String)"samplingMode", (ArgumentType)StringArgumentType.word()).suggests(SAMPLING_MODE_SUGGESTIONS).requires(src -> src.hasPermission(2))).executes(ctx -> {
            DebugData.SamplingMode samplingMode;
            String raw = StringArgumentType.getString((CommandContext)ctx, (String)"samplingMode");
            try {
                samplingMode = DebugData.SamplingMode.valueOf(raw.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException ex) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("Unknown sampling mode: " + raw)));
                return 0;
            }
            Structurify.getConfig().getDebugData().setSamplingMode(samplingMode);
            Structurify.getConfig().getDebugData().clearStructureFlatnessCheckOverviews();
            Structurify.getConfig().getDebugData().clearStructureFlatnessCheckSamples();
            Structurify.getConfig().getDebugData().clearStructureBiomeCheckOverviews();
            Structurify.getConfig().getDebugData().clearStructureBiomeCheckSamples();
            StructurifyCommand.reloadStructureChecks((CommandContext<CommandSourceStack>)ctx);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Structurify debug sampling mode changed to " + String.valueOf((Object)samplingMode) + ".")), !((CommandSourceStack)ctx.getSource()).isPlayer());
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"structures").requires(src -> src.hasPermission(2))).executes(ctx -> StructurifyCommand.getStructures((CommandSourceStack)ctx.getSource())))));
    }

    private static void reloadStructureChecks(CommandContext<CommandSourceStack> ctx) {
        ServerLevel serverLevel = ((CommandSourceStack)ctx.getSource()).getLevel();
        BlockPos blockPos = BlockPos.containing((Position)((CommandSourceStack)ctx.getSource()).getPosition());
        ChunkPos center = new ChunkPos(blockPos);
        ServerChunkCache chunkSource = serverLevel.getChunkSource();
        ChunkGenerator chunkGenerator = chunkSource.getGenerator();
        BiomeSource biomeSource = chunkGenerator.getBiomeSource();
        RandomState randomState = chunkSource.randomState();
        int viewDistance = ((CommandSourceStack)ctx.getSource()).getServer().getPlayerList().getViewDistance();
        int chunkRadius = Math.max(1, (int)((double)viewDistance * 1.33));
        for (int dz = -chunkRadius; dz <= chunkRadius; ++dz) {
            for (int dx = -chunkRadius; dx <= chunkRadius; ++dx) {
                ChunkPos chunkPos = new ChunkPos(center.x + dx, center.z + dz);
                LevelChunk chunk = chunkSource.getChunkNow(chunkPos.x, chunkPos.z);
                if (chunk == null) continue;
                for (Map.Entry structureStartEntry : chunk.getAllStarts().entrySet()) {
                    StructureChecker.debugCheckStructure((StructureStart)structureStartEntry.getValue(), (StructurifyStructure)structureStartEntry.getKey(), chunkGenerator, (LevelHeightAccessor)serverLevel, randomState, biomeSource);
                }
            }
        }
    }

    private static int getStructures(CommandSourceStack source) {
        ServerLevel level = source.getLevel();
        BlockPos pos = BlockPos.containing((Position)source.getPosition());
        return 0;
    }

    private static int locateStructure(CommandSourceStack source, ResourceOrTagKeyArgument.Result<Structure> structure) throws CommandSyntaxException {
        ServerLevel serverLevel = source.getLevel();
        BlockPos blockPos = BlockPos.containing((Position)source.getPosition());
        Registry registry = serverLevel.registryAccess().lookupOrThrow(Registries.STRUCTURE);
        HolderSet holderSet = (HolderSet)LocateCommandInvoker.structurify$invokeGetHolders(structure, (Registry<Structure>)registry).orElseThrow(() -> LocateCommandInvoker.structurify$getStructureInvalidError().create((Object)structure.asPrintable()));
        source.sendSuccess(() -> Component.literal((String)("Locating " + structure.asPrintable() + " in the radius of 6400 chunks")), false);
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)Util.TICKER);
        CompletableFuture.supplyAsync(() -> serverLevel.getChunkSource().getGenerator().findNearestMapStructure(serverLevel, holderSet, blockPos, 6400, false), (Executor)Util.backgroundExecutor()).thenAcceptAsync(pair -> {
            stopwatch.stop();
            source.getServer().execute(() -> {
                if (pair == null) {
                    source.sendFailure((Component)Component.translatable((String)LocateCommandInvoker.structurify$getStructureNotFoundError().create((Object)structure.asPrintable()).getLocalizedMessage()));
                } else {
                    LocateCommand.showLocateResult((CommandSourceStack)source, (ResourceOrTagKeyArgument.Result)structure, (BlockPos)blockPos, (Pair)pair, (String)"commands.locate.structure.success", (boolean)false, (Duration)stopwatch.elapsed());
                }
            });
        }, (Executor)Util.backgroundExecutor());
        return 0;
    }
}

