/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.neoforge;

import com.faboslav.structurify.common.StructurifyClient;
import net.minecraft.client.Minecraft;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;

public final class StructurifyNeoForgeClient {
    public static void init(IEventBus modEventBus, IEventBus eventBus) {
        StructurifyClient.init();
        modEventBus.addListener(StructurifyNeoForgeClient::onClientSetup);
        eventBus.addListener(StructurifyNeoForgeClient::onRenderLevelStage);
    }

    private static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (client, screen) -> StructurifyClient.getConfigScreen(screen)));
    }

    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        StructurifyClient.getDebugRenderer().render(Minecraft.getInstance(), event.getPoseStack(), null);
    }
}

