/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.mixin;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.config.data.StructureData;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Optional;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3079;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7066;
import net.minecraft.class_7924;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_3079.class})
public class LocateCommandMixin {
    @WrapMethod(method={"locateStructure"})
    private static int structurify$executeLocateStructure(class_2168 source, class_7066.class_7068<class_3195> predicate, Operation<Integer> original) throws CommandSyntaxException {
        if (Structurify.getConfig().disableAllStructures) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"command.structurify.locate.exception.all_structures_are_disabled")).create();
        }
        Optional structureRegistryKey = predicate.method_41173().left();
        Optional structureTagKey = predicate.method_41173().right();
        if (structureRegistryKey.isPresent()) {
            String structureId = ((class_5321)structureRegistryKey.get()).method_29177().toString();
            if (LocateCommandMixin.structurify$isStructureDisabled(structureId)) {
                throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"command.structurify.locate.structure_is_disabled", (Object[])new Object[]{structureId})).create();
            }
        } else if (structureTagKey.isPresent()) {
            try {
                source.method_9225().method_30349().method_30530(class_7924.field_41246).method_46733((class_6862)structureTagKey.get()).ifPresent(tagStructures -> {
                    boolean areAllStructuresInTagDisabled = true;
                    for (class_6880 tagStructure : tagStructures) {
                        String tagStructureId = ((class_5321)tagStructure.method_40230().get()).method_29177().toString();
                        if (LocateCommandMixin.structurify$isStructureDisabled(tagStructureId)) continue;
                        areAllStructuresInTagDisabled = false;
                    }
                    if (areAllStructuresInTagDisabled) {
                        throw new RuntimeException((Throwable)new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"command.structurify.locate.structure_is_disabled", (Object[])new Object[]{"#" + String.valueOf(((class_6862)structureTagKey.get()).comp_327())})).create());
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof CommandSyntaxException) {
                    throw (CommandSyntaxException)e.getCause();
                }
                throw e;
            }
        }
        return (Integer)original.call(new Object[]{source, predicate});
    }

    @Unique
    private static boolean structurify$isStructureDisabled(String structureId) {
        StructureData structureData = Structurify.getConfig().getStructureData().getOrDefault(structureId, null);
        if (structureData == null) {
            return false;
        }
        return structureData.isDisabled();
    }
}

