/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.world.level.structure.checks;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.api.StructurifyChunkGenerator;
import com.faboslav.structurify.common.api.StructurifyStructure;
import com.faboslav.structurify.common.config.data.StructureData;
import com.faboslav.structurify.common.config.data.structure.BiomeCheckData;
import com.faboslav.structurify.common.config.data.structure.FlatnessCheckData;
import com.faboslav.structurify.common.util.BiomeUtil;
import com.faboslav.structurify.world.level.structure.checks.StructureBiomeCheck;
import com.faboslav.structurify.world.level.structure.checks.StructureCheckData;
import com.faboslav.structurify.world.level.structure.checks.StructureFlatnessCheck;
import com.faboslav.structurify.world.level.structure.checks.StructureOverlapCheck;
import java.util.Map;
import net.minecraft.class_1923;
import net.minecraft.class_1966;
import net.minecraft.class_1973;
import net.minecraft.class_2338;
import net.minecraft.class_2794;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3449;
import net.minecraft.class_5539;
import net.minecraft.class_7138;
import org.jetbrains.annotations.Nullable;

public final class StructureChecker {
    public static boolean checkStructure(class_3449 structureStart, @Nullable class_2960 structureId, StructurifyStructure structure, class_2794 chunkGenerator, class_5539 heightAccessor, class_7138 randomState, class_1966 biomeSource) {
        if (structureId == null) {
            structureId = structure.structurify$getStructureIdentifier();
        }
        if (structureId == null) {
            return true;
        }
        StructureCheckData structureCheckData = new StructureCheckData(structureId, structure, structureStart);
        long structureCheckId = StructureChecker.generateStructureCheckId(structureId, structureCheckData.getStructureCenter());
        StructurifyChunkGenerator structurifyChunkGenerator = (StructurifyChunkGenerator)chunkGenerator;
        Map<Long, Boolean> cachedBiomeChecks = structurifyChunkGenerator.structurify$getBiomeChecks();
        boolean biomeCheckResult = cachedBiomeChecks.computeIfAbsent(structureCheckId, id -> StructureChecker.checkBiomes(structureCheckData, biomeSource, randomState));
        if (!biomeCheckResult) {
            return false;
        }
        Map<Long, Boolean> cachedFlatnessChecks = structurifyChunkGenerator.structurify$getFlatnessChecks();
        boolean flatnessCheckResult = cachedFlatnessChecks.computeIfAbsent(structureCheckId, id -> StructureChecker.checkFlatness(structureCheckData, chunkGenerator, heightAccessor, randomState));
        if (!flatnessCheckResult) {
            return false;
        }
        Map<Long, Boolean> cachedOverlapChecks = structurifyChunkGenerator.structurify$getOverlapChecks();
        boolean overlapCheckResult = cachedOverlapChecks.computeIfAbsent(structureCheckId, id -> StructureChecker.checkOverlap(structureCheckData, structurifyChunkGenerator));
        return overlapCheckResult;
    }

    public static void debugCheckStructure(class_3449 structureStart, StructurifyStructure structure, class_2794 chunkGenerator, class_5539 heightAccessor, class_7138 randomState, class_1966 biomeSource) {
        class_2960 structureId = structure.structurify$getStructureIdentifier();
        StructureCheckData structureCheckData = new StructureCheckData(structureId, structure, structureStart);
        StructureChecker.checkBiomes(structureCheckData, biomeSource, randomState);
        StructureChecker.checkFlatness(structureCheckData, chunkGenerator, heightAccessor, randomState);
        StructureChecker.checkOverlap(structureCheckData, (StructurifyChunkGenerator)chunkGenerator);
    }

    private static boolean checkBiomes(StructureCheckData structureCheckData, class_1966 biomeSource, class_7138 randomState) {
        StructurifyStructure structure = structureCheckData.getStructure();
        BiomeCheckData biomeCheckData = StructureBiomeCheck.getBiomeCheckData(structureCheckData);
        if (biomeCheckData == null || !biomeCheckData.isEnabled()) {
            return true;
        }
        if (biomeSource instanceof class_1973) {
            return true;
        }
        StructureData structureData = structure.structurify$getStructureData();
        if (structureData == null) {
            return true;
        }
        boolean isOceanStructure = structure.structurify$getStructureBiomes().method_40239().map(h -> h.method_40230().orElse(null)).anyMatch(k -> k != null && BiomeUtil.getOceanBiomes().contains(k));
        if (isOceanStructure) {
            return true;
        }
        boolean biomeCheckResult = StructureBiomeCheck.checkBiomes(structureCheckData, biomeCheckData, biomeSource, randomState);
        return biomeCheckResult;
    }

    private static boolean checkFlatness(StructureCheckData structureCheckData, class_2794 chunkGenerator, class_5539 heightAccessor, class_7138 randomState) {
        StructurifyStructure structure = structureCheckData.getStructure();
        FlatnessCheckData flatnessCheckData = StructureFlatnessCheck.getFlatnessCheckData(structureCheckData);
        if (flatnessCheckData == null || !flatnessCheckData.isEnabled()) {
            return true;
        }
        StructureData structureData = structure.structurify$getStructureData();
        if (structureData == null) {
            return true;
        }
        class_2893.class_2895 structureStep = structureData.getStep();
        if (structureStep != class_2893.class_2895.field_13173 && structureStep != class_2893.class_2895.field_13171) {
            return true;
        }
        boolean isOceanStructure = structure.structurify$getStructureBiomes().method_40239().map(h -> h.method_40230().orElse(null)).anyMatch(k -> k != null && BiomeUtil.getOceanBiomes().contains(k));
        if (isOceanStructure) {
            return true;
        }
        boolean flatnessCheckResult = StructureFlatnessCheck.checkFlatness(structureCheckData, flatnessCheckData, chunkGenerator, heightAccessor, randomState);
        return flatnessCheckResult;
    }

    private static boolean checkOverlap(StructureCheckData structureCheckData, StructurifyChunkGenerator chunkGenerator) {
        if (!Structurify.getConfig().preventStructureOverlap) {
            return true;
        }
        StructureData structureData = structureCheckData.getStructure().structurify$getStructureData();
        if (structureData == null) {
            return true;
        }
        class_2893.class_2895 structureStep = structureData.getStep();
        if (structureStep == class_2893.class_2895.field_13174) {
            return true;
        }
        boolean overlapCheckResult = StructureOverlapCheck.checkForOverlap(structureCheckData, chunkGenerator);
        return !overlapCheckResult;
    }

    public static long generateStructureCheckId(class_2960 structureId, class_2338 structureCenter) {
        long structHash = structureId.hashCode();
        structHash ^= structHash >>> 33;
        structHash *= -49064778989728563L;
        structHash ^= structHash >>> 33;
        structHash *= -4265267296055464877L;
        structHash ^= structHash >>> 33;
        return Long.rotateLeft(structHash, 23) ^ Long.rotateLeft(class_1923.method_37232((class_2338)structureCenter), 11);
    }
}

