/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.util;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.config.data.StructureData;
import com.faboslav.structurify.common.modcompat.ModChecker;
import com.faboslav.structurify.common.modcompat.ModCompat;
import com.faboslav.structurify.common.registry.StructurifyRegistryManagerProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;

public final class BiomeUtil {
    public static TagKey<Biome> C_IS_OCEAN = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)Structurify.makeNamespacedId("c:is_ocean"));
    public static TagKey<Biome> C_IS_RIVER = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)Structurify.makeNamespacedId("c:is_river"));

    public static Set<ResourceKey<Biome>> getOceanBiomes() {
        HolderLookup.RegistryLookup<Biome> biomeRegistry = StructurifyRegistryManagerProvider.getBiomeRegistry();
        if (biomeRegistry == null) {
            return new HashSet<ResourceKey<Biome>>();
        }
        HashSet<ResourceKey<Biome>> oceanBiomes = new HashSet<ResourceKey<Biome>>();
        biomeRegistry.get(BiomeTags.IS_OCEAN).ifPresent(named -> oceanBiomes.addAll(named.stream().map(h -> h.unwrapKey().orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet())));
        biomeRegistry.get(BiomeTags.IS_RIVER).ifPresent(named -> oceanBiomes.addAll(named.stream().map(h -> h.unwrapKey().orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet())));
        biomeRegistry.get(C_IS_OCEAN).ifPresent(named -> oceanBiomes.addAll(named.stream().map(h -> h.unwrapKey().orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet())));
        biomeRegistry.get(C_IS_RIVER).ifPresent(named -> oceanBiomes.addAll(named.stream().map(h -> h.unwrapKey().orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet())));
        return oceanBiomes;
    }

    public static HolderSet<Biome> getBiomes(ResourceLocation structureId, HolderSet<Biome> originalBiomes) {
        if (structureId == null || !Structurify.getConfig().getStructureData().containsKey(structureId.toString())) {
            return originalBiomes;
        }
        HolderLookup.RegistryLookup<Biome> biomeRegistry = StructurifyRegistryManagerProvider.getBiomeRegistry();
        if (biomeRegistry == null) {
            return originalBiomes;
        }
        StructureData structureData = Structurify.getConfig().getStructureData().get(structureId.toString());
        List<String> biomeIds = structureData.getBiomes();
        return BiomeUtil.getBiomeHolders(biomeIds, biomeRegistry);
    }

    public static HolderSet<Biome> getBlacklistedBiomes(ResourceLocation structureId) {
        if (structureId == null || !Structurify.getConfig().getStructureData().containsKey(structureId.toString())) {
            return HolderSet.direct(new ArrayList());
        }
        HolderLookup.RegistryLookup<Biome> biomeRegistry = StructurifyRegistryManagerProvider.getBiomeRegistry();
        if (biomeRegistry == null) {
            return HolderSet.direct(new ArrayList());
        }
        StructureData structureData = Structurify.getConfig().getStructureData().get(structureId.toString());
        List<String> blacklistedBiomeIds = structureData.getBiomeCheckData().getBlacklistedBiomes();
        return BiomeUtil.getBiomeHolders(blacklistedBiomeIds, biomeRegistry);
    }

    public static HolderSet<Biome> getBiomeHolders(List<String> biomeIds, HolderLookup.RegistryLookup<Biome> biomeRegistry) {
        for (ModCompat modCompat : ModChecker.BIOME_REPLACER_COMPATS) {
            try {
                List<String> replacedBiomeIds = modCompat.getReplacedBiomes(biomeIds);
                biomeIds.addAll(replacedBiomeIds);
            }
            catch (Throwable e) {
                Structurify.getLogger().error("Failed to get replaced biomes from mod compat");
                e.printStackTrace();
            }
        }
        ArrayList<Object> biomeHolders = new ArrayList<Object>();
        for (String biomeId : biomeIds) {
            if (biomeId.contains("#")) {
                TagKey biomeTagKey = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)Structurify.makeNamespacedId(biomeId.replace("#", "")));
                HolderSet.Named biomeTagHolder = biomeRegistry.get(biomeTagKey).orElse(null);
                if (biomeTagHolder == null) continue;
                for (Holder biomeHolder : biomeTagHolder.stream().toList()) {
                    biomeHolders.add(biomeHolder);
                }
                continue;
            }
            ResourceKey biomeResourceKey = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)Structurify.makeNamespacedId(biomeId.replace("#", "")));
            Holder.Reference biomeHolder = biomeRegistry.get(biomeResourceKey).orElse(null);
            if (biomeHolder == null) continue;
            biomeHolders.add(biomeHolder);
        }
        return HolderSet.direct(biomeHolders);
    }
}

