/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.checks;

import com.faboslav.structurify.common.config.data.StructureData;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;

public final class JigsawStructureBiomeCheck {
    public static boolean checkBiomes(StructureData structureData, HeightProvider startHeight, Structure.GenerationContext generationContext, HolderSet<Biome> blacklistedBiomes) {
        int biomeCheckDistance = (int)Math.ceil((double)structureData.getBiomeCheckDistance() / 16.0);
        if (biomeCheckDistance == 0 || generationContext.biomeSource() instanceof CheckerboardColumnBiomeSource) {
            return true;
        }
        if (structureData.getBiomeCheckMode() == StructureData.BiomeCheckMode.BLACKLIST && structureData.getBiomeCheckBlacklistedBiomes().isEmpty()) {
            return true;
        }
        ChunkPos chunkPos = generationContext.chunkPos();
        for (int curChunkX = chunkPos.x - biomeCheckDistance; curChunkX <= chunkPos.x + biomeCheckDistance; ++curChunkX) {
            for (int curChunkZ = chunkPos.z - biomeCheckDistance; curChunkZ <= chunkPos.z + biomeCheckDistance; ++curChunkZ) {
                int blockX = curChunkX << 4;
                int blockZ = curChunkZ << 4;
                int surfaceY = generationContext.chunkGenerator().getFirstFreeHeight(blockX, blockZ, Heightmap.Types.WORLD_SURFACE_WG, generationContext.heightAccessor(), generationContext.randomState());
                Holder biome = generationContext.biomeSource().getNoiseBiome(QuartPos.fromBlock((int)blockX), QuartPos.fromBlock((int)surfaceY), QuartPos.fromBlock((int)blockZ), generationContext.randomState().sampler());
                if (structureData.getBiomeCheckMode() == StructureData.BiomeCheckMode.STRICT && !generationContext.validBiome().test(biome)) {
                    return false;
                }
                if (structureData.getBiomeCheckMode() != StructureData.BiomeCheckMode.BLACKLIST || !blacklistedBiomes.contains(biome)) continue;
                return false;
            }
        }
        return true;
    }
}

