/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.mixin.structure.jigsaw;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.checks.JigsawStructureBiomeCheck;
import com.faboslav.structurify.common.checks.JigsawStructureFlatnessCheck;
import com.faboslav.structurify.common.config.data.StructureData;
import com.faboslav.structurify.common.mixin.structure.StructureMixin;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={JigsawStructure.class})
public abstract class JigsawStructureMixin
extends StructureMixin {
    @Shadow
    @Final
    private HeightProvider startHeight;

    @WrapMethod(method={"findGenerationPoint"})
    private Optional<Structure.GenerationStub> structurify$getStructurePosition(Structure.GenerationContext generationContext, Operation<Optional<Structure.GenerationStub>> original) {
        boolean biomeCheckResult;
        boolean flatnessCheckResult;
        ResourceLocation structureId = this.structurify$getStructureIdentifier();
        if (structureId == null || !Structurify.getConfig().getStructureData().containsKey(structureId.toString())) {
            return (Optional)original.call(new Object[]{generationContext});
        }
        StructureData structureData = Structurify.getConfig().getStructureData().get(structureId.toString());
        if (structureData.isFlatnessCheckEnabled() && !(flatnessCheckResult = JigsawStructureFlatnessCheck.checkFlatness(structureData, this.startHeight, generationContext))) {
            return Optional.empty();
        }
        if (structureData.isBiomeCheckEnabled() && !(biomeCheckResult = JigsawStructureBiomeCheck.checkBiomes(structureData, this.startHeight, generationContext, this.structurify$getStructureBlacklistedBiomes()))) {
            return Optional.empty();
        }
        return (Optional)original.call(new Object[]{generationContext});
    }
}

