/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.registry;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.registry.StructurifyResourcePackProvider;
import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.commands.Commands;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import org.jetbrains.annotations.Nullable;

public final class StructurifyRegistryManagerProvider {
    @Nullable
    private static HolderLookup.Provider registryManager = null;
    private static boolean isLoading = false;

    @Nullable
    public static HolderLookup.Provider getRegistryManager() {
        if (registryManager == null) {
            StructurifyRegistryManagerProvider.loadRegistryManager();
        }
        return registryManager;
    }

    @Nullable
    public static HolderLookup.RegistryLookup<Biome> getBiomeRegistry() {
        HolderLookup.Provider registryManager = StructurifyRegistryManagerProvider.getRegistryManager();
        if (registryManager == null) {
            return null;
        }
        HolderLookup.RegistryLookup biomeRegistry = registryManager.lookup(Registries.BIOME).orElse(null);
        if (biomeRegistry == null) {
            return null;
        }
        return biomeRegistry;
    }

    public static void setRegistryManager(HolderLookup.Provider registryAccess) {
        registryManager = registryAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadRegistryManager() {
        if (isLoading) {
            return;
        }
        isLoading = true;
        try {
            Structurify.getLogger().info("Loading registry manager...");
            ArrayList<RepositorySource> resourcePackProviders = StructurifyResourcePackProvider.getResourcePackProviders();
            for (RepositorySource resourcePackProvider : resourcePackProviders) {
                Structurify.getLogger().info("Registering resource pack provider: " + resourcePackProvider.getClass().getSimpleName());
            }
            PackRepository resourcePackManager = new PackRepository(StructurifyResourcePackProvider.getResourcePackProviders().toArray(new RepositorySource[0]));
            WorldLoader.PackConfig dataPacks = new WorldLoader.PackConfig(resourcePackManager, WorldDataConfiguration.DEFAULT, false, false);
            WorldLoader.InitConfig serverConfig = new WorldLoader.InitConfig(dataPacks, Commands.CommandSelection.INTEGRATED, 2);
            WorldStem saveLoader = (WorldStem)Util.blockUntilDone(executor -> WorldLoader.load((WorldLoader.InitConfig)serverConfig, loadContextSupplierContext -> {
                Registry registry = new MappedRegistry(Registries.LEVEL_STEM, Lifecycle.stable()).freeze();
                WorldDimensions.Complete dimensionsConfig = ((WorldPreset)loadContextSupplierContext.datapackWorldgen().lookupOrThrow(Registries.WORLD_PRESET).getOrThrow(WorldPresets.FLAT).value()).createWorldDimensions().bake(registry);
                return new WorldLoader.DataLoadOutput(null, dimensionsConfig.dimensionsRegistryAccess());
            }, WorldStem::new, (Executor)Util.backgroundExecutor(), (Executor)executor)).get();
            if (saveLoader == null || saveLoader.registries() == null) {
                Structurify.getLogger().error("SaveLoader or CombinedDynamicRegistries is null.");
                return;
            }
            StructurifyRegistryManagerProvider.setRegistryManager((HolderLookup.Provider)saveLoader.registries().compositeAccess());
            Structurify.getLogger().info("Finished loading registry manager");
        }
        catch (Exception exception) {
            Structurify.getLogger().error("Failed to load registry manager.", (Throwable)exception);
        }
        finally {
            isLoading = false;
        }
    }
}

