/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.client.gui;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.config.StructurifyConfig;
import com.faboslav.structurify.common.config.client.gui.StructureSetsConfigScreen;
import com.faboslav.structurify.common.config.client.gui.StructuresConfigScreen;
import com.faboslav.structurify.common.config.client.gui.StructurifyConfigScreenState;
import com.faboslav.structurify.common.events.common.LoadConfigEvent;
import com.faboslav.structurify.common.mixin.yacl.CategoryTabAccessor;
import com.faboslav.structurify.common.mixin.yacl.GroupSeparatorEntryAccessor;
import com.faboslav.structurify.common.util.YACLUtil;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.gui.OptionListWidget;
import dev.isxander.yacl3.gui.YACLScreen;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class StructurifyConfigScreen {
    public Map<String, StructurifyConfigScreenState> screenStates = new HashMap<String, StructurifyConfigScreenState>();

    public Screen generateScreen(Screen parent) {
        StructurifyConfig config = Structurify.getConfig();
        YetAnotherConfigLib.Builder yaclBuilder = YetAnotherConfigLib.createBuilder().title((Component)Component.translatable((String)"gui.structurify.structures_category.title")).save(config::save);
        LoadConfigEvent.EVENT.invoke(new LoadConfigEvent());
        StructuresConfigScreen.createStructuresTab(yaclBuilder, config);
        StructureSetsConfigScreen.createStructureSetsTab(yaclBuilder, config);
        YACLScreen yaclScreen = (YACLScreen)yaclBuilder.build().generateScreen(parent);
        return yaclScreen;
    }

    public void saveScreenState(YACLScreen yaclScreen) {
        Tab currentTab = yaclScreen.tabNavigationBar.getTabManager().getCurrentTab();
        if (currentTab instanceof YACLScreen.CategoryTab) {
            YACLScreen.CategoryTab yaclScreenCategoryTab = (YACLScreen.CategoryTab)currentTab;
            CategoryTabAccessor categoryTab = (CategoryTabAccessor)yaclScreenCategoryTab;
            OptionListWidget optionListWidget = YACLUtil.getOptionListWidget(yaclScreenCategoryTab);
            HashMap<String, Boolean> collapsedGroups = new HashMap<String, Boolean>();
            for (OptionListWidget.Entry entry : optionListWidget.children()) {
                if (!(entry instanceof OptionListWidget.GroupSeparatorEntry)) continue;
                OptionListWidget.GroupSeparatorEntry groupSeparatorEntry = (OptionListWidget.GroupSeparatorEntry)entry;
                GroupSeparatorEntryAccessor yaclGroupSeparatorEntry = (GroupSeparatorEntryAccessor)entry;
                String groupName = yaclGroupSeparatorEntry.getGroup().name().getString();
                if (collapsedGroups.containsKey(groupName)) continue;
                collapsedGroups.put(groupName, groupSeparatorEntry.isExpanded());
            }
            this.screenStates.put(yaclScreen.getTitle().getString(), new StructurifyConfigScreenState(categoryTab.getSearchField().getValue(), optionListWidget.scrollAmount(), collapsedGroups));
        }
    }

    public void loadScreenState(YACLScreen yaclScreen) {
        Tab currentTab = yaclScreen.tabNavigationBar.getTabManager().getCurrentTab();
        if (currentTab instanceof YACLScreen.CategoryTab) {
            YACLScreen.CategoryTab yaclScreenCategoryTab = (YACLScreen.CategoryTab)currentTab;
            StructurifyConfigScreenState screenState = this.screenStates.get(yaclScreen.getTitle().getString());
            if (screenState != null) {
                CategoryTabAccessor categoryTab = (CategoryTabAccessor)yaclScreenCategoryTab;
                OptionListWidget optionListWidget = YACLUtil.getOptionListWidget(yaclScreenCategoryTab);
                categoryTab.getSearchField().setValue(screenState.lastSearchText());
                optionListWidget.setScrollAmount(screenState.lastScrollAmount());
                for (OptionListWidget.Entry entry : optionListWidget.children()) {
                    if (!(entry instanceof OptionListWidget.GroupSeparatorEntry)) continue;
                    OptionListWidget.GroupSeparatorEntry groupSeparatorEntry = (OptionListWidget.GroupSeparatorEntry)entry;
                    GroupSeparatorEntryAccessor yaclGroupSeparatorEntry = (GroupSeparatorEntryAccessor)entry;
                    String groupName = yaclGroupSeparatorEntry.getGroup().name().getString();
                    Boolean isGroupCollapsed = screenState.collapsedGroups().getOrDefault(groupName, false);
                    groupSeparatorEntry.setExpanded(isGroupCollapsed.booleanValue());
                }
            }
        }
    }
}

