/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.data;

import com.faboslav.structurify.common.api.StructurifyRandomSpreadStructurePlacement;
import com.faboslav.structurify.common.api.StructurifyStructurePlacement;
import com.faboslav.structurify.common.config.data.StructureData;
import com.faboslav.structurify.common.config.data.StructureNamespaceData;
import com.faboslav.structurify.common.config.data.StructureSetData;
import com.faboslav.structurify.common.config.data.structure.BiomeCheckData;
import com.faboslav.structurify.common.config.data.structure.FlatnessCheckData;
import com.faboslav.structurify.common.config.data.structure.JigsawData;
import com.faboslav.structurify.common.registry.StructurifyRegistryManagerProvider;
import com.faboslav.structurify.common.util.BiomeUtil;
import com.faboslav.structurify.common.util.JigsawStructureUtil;
import com.faboslav.structurify.common.util.StructureUtil;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;

public final class WorldgenDataProvider {
    private static List<String> biomes = new ArrayList<String>();
    private static Map<String, StructureNamespaceData> structureNamespaceData = new TreeMap<String, StructureNamespaceData>();
    private static Map<String, StructureData> structureData = new TreeMap<String, StructureData>();
    private static Map<String, StructureSetData> structureSetData = new TreeMap<String, StructureSetData>();
    private static final Comparator<String> alphabeticallComparator = (key1, key2) -> {
        boolean isKey1Minecraft = key1.startsWith("minecraft:");
        boolean isKey2Minecraft = key2.startsWith("minecraft:");
        if (isKey1Minecraft && !isKey2Minecraft) {
            return -1;
        }
        if (!isKey1Minecraft && isKey2Minecraft) {
            return 1;
        }
        return key1.compareTo((String)key2);
    };

    public static List<String> getBiomes() {
        return biomes;
    }

    public static Map<String, StructureNamespaceData> getStructureNamespaces() {
        return structureNamespaceData;
    }

    public static Map<String, StructureData> getStructures() {
        return structureData;
    }

    public static Map<String, StructureSetData> getStructureSets() {
        return structureSetData;
    }

    public static void loadWorldgenData() {
        biomes = WorldgenDataProvider.loadBiomes();
        structureNamespaceData = WorldgenDataProvider.loadStructureNamespaces();
        structureData = WorldgenDataProvider.loadStructures();
        structureSetData = WorldgenDataProvider.loadStructureSets();
    }

    public static List<String> loadBiomes() {
        HolderLookup.RegistryLookup<Biome> biomeRegistry = StructurifyRegistryManagerProvider.getBiomeRegistry();
        if (biomeRegistry == null) {
            return Collections.emptyList();
        }
        ArrayList<String> biomes = new ArrayList<String>();
        for (HolderSet.Named biomeTag : biomeRegistry.m_214063_().toList()) {
            biomes.add("#" + ((TagKey)biomeTag.m_245234_().get()).f_203868_().toString());
        }
        for (Holder.Reference biome : biomeRegistry.m_214062_().toList()) {
            biomes.add(((ResourceKey)biome.m_203543_().get()).m_135782_().toString());
        }
        return biomes;
    }

    public static Map<String, StructureNamespaceData> loadStructureNamespaces() {
        HolderLookup.Provider registryManager = StructurifyRegistryManagerProvider.getRegistryManager();
        if (registryManager == null) {
            return Collections.emptyMap();
        }
        HolderLookup.RegistryLookup structureRegistry = registryManager.m_255025_(Registries.f_256944_);
        TreeMap<String, StructureNamespaceData> structuresNamespaces = new TreeMap<String, StructureNamespaceData>(alphabeticallComparator);
        for (Holder.Reference structureReference : structureRegistry.m_214062_().toList()) {
            String structureNamespace = structureReference.m_205785_().m_135782_().m_135827_();
            if (structuresNamespaces.containsKey(structureNamespace)) continue;
            structuresNamespaces.put(structureNamespace, new StructureNamespaceData());
        }
        structuresNamespaces.put(StructureNamespaceData.GLOBAL_NAMESPACE_IDENTIFIER, new StructureNamespaceData());
        return structuresNamespaces;
    }

    public static Map<String, StructureData> loadStructures() {
        HolderLookup.Provider registryManager = StructurifyRegistryManagerProvider.getRegistryManager();
        if (registryManager == null) {
            return Collections.emptyMap();
        }
        HolderLookup.RegistryLookup structureRegistry = registryManager.m_255025_(Registries.f_256944_);
        HolderLookup.RegistryLookup biomeRegistry = registryManager.m_255025_(Registries.f_256952_);
        TreeMap<String, StructureData> structures = new TreeMap<String, StructureData>(alphabeticallComparator);
        for (Holder.Reference structureReference : structureRegistry.m_214062_().toList()) {
            List<String> biomes2;
            HolderSet<Biome> defaultBiomeHolders;
            Structure structure = (Structure)structureReference.m_203334_();
            String structureId = structureReference.m_205785_().m_135782_().toString();
            Either biomeStorage = structure.m_226559_().m_203440_();
            ArrayList<String> defaultBiomes = new ArrayList<String>();
            biomeStorage.mapLeft(biomeTagKey -> {
                biomeRegistry.m_254901_(biomeTagKey).ifPresent(biomes -> {
                    for (Holder biome : biomes) {
                        String biomeKey = ((ResourceKey)biome.m_203543_().get()).m_135782_().toString();
                        if (defaultBiomes.contains(biomeKey)) continue;
                        defaultBiomes.add(biomeKey);
                    }
                });
                return null;
            });
            biomeStorage.mapRight(biomes -> {
                for (Holder biome : biomes) {
                    String biomeKey = ((ResourceKey)biome.m_203543_().get()).m_135782_().toString();
                    if (defaultBiomes.contains(biomeKey)) continue;
                    defaultBiomes.add(biomeKey);
                }
                return null;
            });
            StructureData structureData = new StructureData(defaultBiomes, structure.m_226619_(), structure.m_226620_());
            if (JigsawStructureUtil.isJigsawLikeStructure(structure)) {
                int horizontalMaxDistanceFromCenter = JigsawStructureUtil.getMaxDistanceFromCenterForStructure(structure);
                int verticalMaxDistanceFromCenter = JigsawStructureUtil.getMaxDistanceFromCenterForStructure(structure);
                int maxSize = JigsawStructureUtil.getSizeForStructure(structure);
                structureData.setJigsawData(new JigsawData(maxSize, horizontalMaxDistanceFromCenter, verticalMaxDistanceFromCenter));
            }
            if (BiomeUtil.isWaterStructure(defaultBiomeHolders = BiomeUtil.getBiomeHolders(defaultBiomes, (HolderLookup.RegistryLookup<Biome>)biomeRegistry))) {
                FlatnessCheckData flatnessCheckData = structureData.getFlatnessCheckData();
                flatnessCheckData.defaultOverrideGlobalFlatnessCheck(true);
                flatnessCheckData.overrideGlobalFlatnessCheck(true);
                flatnessCheckData.defaultEnable(false);
                flatnessCheckData.enable(false);
                BiomeCheckData biomeCheckData = structureData.getBiomeCheckData();
                biomeCheckData.defaultOverrideGlobalBiomeCheck(true);
                biomeCheckData.overrideGlobalBiomeCheck(true);
                biomeCheckData.defaultEnable(false);
                biomeCheckData.enable(false);
            }
            if (StructureUtil.isUndergroundStructure(structureData.getStep())) {
                FlatnessCheckData flatnessCheckData = structureData.getFlatnessCheckData();
                flatnessCheckData.defaultOverrideGlobalFlatnessCheck(true);
                flatnessCheckData.overrideGlobalFlatnessCheck(true);
                flatnessCheckData.defaultEnable(false);
                flatnessCheckData.enable(false);
            }
            if (structureId.equals("minecraft:shipwreck_beached")) {
                FlatnessCheckData flatnessCheckData = structureData.getFlatnessCheckData();
                flatnessCheckData.defaultOverrideGlobalFlatnessCheck(true);
                flatnessCheckData.overrideGlobalFlatnessCheck(true);
                flatnessCheckData.defaultEnable(false);
                flatnessCheckData.enable(false);
            }
            if (structureId.equals("nova_structures:illager_camp") && (biomes2 = structureData.getBiomes()).contains("minecraft:river")) {
                biomes2.remove("minecraft:river");
            }
            if (structureId.equals("alexscaves:acid_pit") || structureId.equals("alexscaves:cake_cave") || structureId.equals("alexscaves:dino_bowl") || structureId.equals("alexscaves:ferrocave") || structureId.equals("alexscaves:forlorn_canyon") || structureId.equals("alexscaves:ocean_trench")) {
                FlatnessCheckData flatnessCheckData = structureData.getFlatnessCheckData();
                flatnessCheckData.overrideGlobalFlatnessCheck(true);
                flatnessCheckData.enable(false);
                BiomeCheckData biomeCheckData = structureData.getBiomeCheckData();
                biomeCheckData.overrideGlobalBiomeCheck(true);
                biomeCheckData.enable(false);
            }
            structures.put(structureId, structureData);
        }
        return structures;
    }

    public static Map<String, StructureSetData> loadStructureSets() {
        HolderLookup.Provider registryManager = StructurifyRegistryManagerProvider.getRegistryManager();
        if (registryManager == null) {
            return Collections.emptyMap();
        }
        HolderLookup.RegistryLookup structureSetRegistry = registryManager.m_255025_(Registries.f_256998_);
        TreeMap<String, StructureSetData> structureSets = new TreeMap<String, StructureSetData>();
        for (Holder.Reference structureSetReference : structureSetRegistry.m_214062_().toList()) {
            StructureSet structureSet = (StructureSet)structureSetReference.m_203334_();
            ResourceLocation structureSetId = structureSetReference.m_205785_().m_135782_();
            String structureSetStringId = structureSetId.toString();
            StructurePlacement structureSetPlacement = structureSet.f_210004_();
            int salt = 0;
            float frequency = 0.0f;
            int spacing = 0;
            int separation = 0;
            if (structureSetPlacement instanceof StructurifyStructurePlacement) {
                StructurifyStructurePlacement structurePlacement = (StructurifyStructurePlacement)structureSetPlacement;
                salt = structurePlacement.structurify$getOriginalSalt();
                frequency = structurePlacement.structurify$getOriginalFrequency();
            }
            if (structureSetPlacement instanceof StructurifyRandomSpreadStructurePlacement) {
                StructurifyRandomSpreadStructurePlacement randomSpreadStructurePlacement = (StructurifyRandomSpreadStructurePlacement)structureSetPlacement;
                spacing = randomSpreadStructurePlacement.structurify$getOriginalSpacing();
                separation = randomSpreadStructurePlacement.structurify$getOriginalSeparation();
            }
            StructureSetData structureSetData = new StructureSetData(salt, frequency, spacing, separation);
            if (structureSetStringId.equals("alexscaves:acid_pit") || structureSetStringId.equals("alexscaves:cake_cave") || structureSetStringId.equals("alexscaves:dino_bowl") || structureSetStringId.equals("alexscaves:ferrocave") || structureSetStringId.equals("alexscaves:forlorn_canyon") || structureSetStringId.equals("alexscaves:ocean_trench")) {
                structureSetData.setOverrideGlobalSpacingAndSeparationModifier(true);
            }
            structureSets.put(structureSetStringId, structureSetData);
        }
        return structureSets;
    }
}

