/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.neoforge;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.commands.StructurifyCommand;
import com.faboslav.structurify.common.events.common.LoadConfigEvent;
import com.faboslav.structurify.common.events.common.UpdateRegistriesEvent;
import com.faboslav.structurify.common.registry.StructurifyRegistryManagerProvider;
import com.faboslav.structurify.neoforge.StructurifyNeoForgeClient;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;

@Mod(value="structurify")
public final class StructurifyNeoForge {
    public StructurifyNeoForge(ModContainer modContainer, IEventBus modEventBus) {
        IEventBus eventBus = NeoForge.EVENT_BUS;
        Structurify.init();
        if (FMLEnvironment.getDist() == Dist.CLIENT) {
            StructurifyNeoForgeClient.init(modEventBus, eventBus);
        }
        eventBus.addListener(StructurifyNeoForge::registerCommand);
        eventBus.addListener(StructurifyNeoForge::onResourceManagerReload);
        eventBus.addListener(StructurifyNeoForge::onServerAboutToStart);
    }

    private static void registerCommand(RegisterCommandsEvent event) {
        StructurifyCommand.createCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    private static void onResourceManagerReload(TagsUpdatedEvent event) {
        if (event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED) {
            return;
        }
        HolderLookup.Provider registryAccess = event.getLookupProvider();
        StructurifyRegistryManagerProvider.setRegistryManager(registryAccess);
        LoadConfigEvent.EVENT.invoke(new LoadConfigEvent());
    }

    private static void onServerAboutToStart(ServerAboutToStartEvent event) {
        StructurifyRegistryManagerProvider.setRegistryManager((HolderLookup.Provider)event.getServer().registryAccess());
        UpdateRegistriesEvent.EVENT.invoke(new UpdateRegistriesEvent((HolderLookup.Provider)event.getServer().registryAccess()));
    }
}

