/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.world.level.structure.checks;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.api.StructurifyStructure;
import com.faboslav.structurify.common.config.data.StructureData;
import com.faboslav.structurify.common.config.data.structure.BiomeCheckData;
import com.faboslav.structurify.world.level.structure.checks.StructureCheckData;
import com.faboslav.structurify.world.level.structure.checks.debug.StructureBiomeCheckOverview;
import com.faboslav.structurify.world.level.structure.checks.debug.StructureBiomeCheckSample;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_5321;
import net.minecraft.class_5742;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7138;

public final class StructureBiomeCheck {
    public static BiomeCheckData getBiomeCheckData(StructurifyStructure structure) {
        BiomeCheckData globalBiomeCheckData = structure.structurify$getGlobalStructureNamespaceData().getBiomeCheckData();
        BiomeCheckData namespaceBiomeCheckData = structure.structurify$getStructureNamespaceData().getBiomeCheckData();
        BiomeCheckData structureBiomeCheckData = structure.structurify$getStructureData().getBiomeCheckData();
        BiomeCheckData biomeCheckDataToCheck = globalBiomeCheckData;
        if (namespaceBiomeCheckData.isOverridingGlobalBiomeCheck() || namespaceBiomeCheckData.isEnabled()) {
            biomeCheckDataToCheck = namespaceBiomeCheckData;
        }
        if (structureBiomeCheckData.isOverridingGlobalBiomeCheck() || structureBiomeCheckData.isEnabled()) {
            biomeCheckDataToCheck = structureBiomeCheckData;
        }
        return biomeCheckDataToCheck;
    }

    public static boolean checkBiomes(StructureCheckData structureCheckData, class_1966 biomeSource, class_7138 randomState) {
        StructurifyStructure structure = structureCheckData.getStructure();
        StructureData structureData = structure.structurify$getStructureData();
        BiomeCheckData biomeCheckData = structureData.getBiomeCheckData();
        class_6885<class_1959> allowedBiomes = structure.structurify$getStructureBiomes();
        class_6885<class_1959> blacklistedBiomes = structure.structurify$getStructureBlacklistedBiomes();
        BiomeCheckData.BiomeCheckMode mode = biomeCheckData.getMode();
        if (mode == BiomeCheckData.BiomeCheckMode.BLACKLIST && biomeCheckData.getBlacklistedBiomes().isEmpty()) {
            return true;
        }
        int blockY = structureCheckData.getStructureCenter().method_10264();
        int sampleQuartY = class_5742.method_33100((int)blockY);
        class_6544.class_6552 sampler = randomState.method_42371();
        for (int[] pos : structureCheckData.getStructurePieceSamples()) {
            int blockX = pos[0];
            int blockZ = pos[1];
            int quartX = class_5742.method_33100((int)blockX);
            int quartZ = class_5742.method_33100((int)blockZ);
            class_6880 biome = biomeSource.method_38109(quartX, sampleQuartY, quartZ, sampler);
            if (mode == BiomeCheckData.BiomeCheckMode.STRICT) {
                if (!allowedBiomes.method_40241(biome)) {
                    StructureBiomeCheck.debugAddStructureBiomeCheckSample(structureCheckData, blockX, blockY, blockZ, (class_6880<class_1959>)biome, false);
                    StructureBiomeCheck.debugAddStructureBiomeCheckOverview(structureCheckData, false);
                    return false;
                }
            } else if (mode == BiomeCheckData.BiomeCheckMode.BLACKLIST && blacklistedBiomes.method_40241(biome)) {
                StructureBiomeCheck.debugAddStructureBiomeCheckSample(structureCheckData, blockX, blockY, blockZ, (class_6880<class_1959>)biome, false);
                StructureBiomeCheck.debugAddStructureBiomeCheckOverview(structureCheckData, false);
                return false;
            }
            StructureBiomeCheck.debugAddStructureBiomeCheckSample(structureCheckData, blockX, blockY, blockZ, (class_6880<class_1959>)biome, true);
        }
        StructureBiomeCheck.debugAddStructureBiomeCheckOverview(structureCheckData, true);
        return true;
    }

    private static void debugAddStructureBiomeCheckOverview(StructureCheckData structureCheckData, boolean result) {
        Structurify.getConfig().getDebugData().addStructureBiomeCheckOverview(class_1923.method_37232((class_2338)structureCheckData.getStructureCenter()), new StructureBiomeCheckOverview(structureCheckData.getStructureId(), structureCheckData.getStructureStart().method_14969(), structureCheckData.getStructurePieces(), structureCheckData.getStructure().structurify$getStructureData().getBiomeCheckData().getMode(), structureCheckData.getStructurePieceSamples().length, result));
    }

    private static void debugAddStructureBiomeCheckSample(StructureCheckData structureCheckData, int x, int y, int z, class_6880<class_1959> biome, boolean result) {
        Structurify.getConfig().getDebugData().addStructureBiomeCheckSample(class_1923.method_37232((class_2338)structureCheckData.getStructureCenter()), new StructureBiomeCheckSample(structureCheckData.getStructureId(), x, y, z, ((class_5321)biome.method_40230().get()).method_29177(), result));
    }
}

