/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.world.level.structure.checks;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.api.StructurifyChunkGenerator;
import com.faboslav.structurify.common.api.StructurifyStructure;
import com.faboslav.structurify.common.config.data.StructureData;
import com.faboslav.structurify.common.config.data.structure.BiomeCheckData;
import com.faboslav.structurify.common.config.data.structure.FlatnessCheckData;
import com.faboslav.structurify.common.util.BiomeUtil;
import com.faboslav.structurify.world.level.structure.checks.StructureBiomeCheck;
import com.faboslav.structurify.world.level.structure.checks.StructureCheckData;
import com.faboslav.structurify.world.level.structure.checks.StructureFlatnessCheck;
import com.faboslav.structurify.world.level.structure.checks.StructureOverlapCheck;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.jetbrains.annotations.Nullable;

public final class StructureChecker {
    public static boolean checkStructure(StructureStart structureStart, @Nullable ResourceLocation structureId, StructurifyStructure structure, ChunkGenerator chunkGenerator, LevelHeightAccessor heightAccessor, RandomState randomState, BiomeSource biomeSource) {
        StructureCheckData structureCheckData;
        boolean biomeCheckResult;
        if (structureId == null) {
            structureId = structure.structurify$getStructureIdentifier();
        }
        if (!(biomeCheckResult = StructureChecker.checkBiomes(structureCheckData = new StructureCheckData(structureId, structure, structureStart), biomeSource, randomState))) {
            return false;
        }
        boolean flatnessCheckResult = StructureChecker.checkFlatness(structureCheckData, chunkGenerator, heightAccessor, randomState);
        if (!flatnessCheckResult) {
            return false;
        }
        boolean overlapCheckResult = StructureChecker.checkOverlap(structureCheckData, chunkGenerator);
        return overlapCheckResult;
    }

    public static void debugCheckStructure(StructureStart structureStart, StructurifyStructure structure, ChunkGenerator chunkGenerator, LevelHeightAccessor heightAccessor, RandomState randomState, BiomeSource biomeSource) {
        ResourceLocation structureId = structure.structurify$getStructureIdentifier();
        StructureCheckData structureCheckData = new StructureCheckData(structureId, structure, structureStart);
        StructureChecker.checkBiomes(structureCheckData, biomeSource, randomState);
        StructureChecker.checkFlatness(structureCheckData, chunkGenerator, heightAccessor, randomState);
        StructureChecker.checkOverlap(structureCheckData, chunkGenerator);
    }

    private static boolean checkBiomes(StructureCheckData structureCheckData, BiomeSource biomeSource, RandomState randomState) {
        StructurifyStructure structure = structureCheckData.getStructure();
        BiomeCheckData biomeCheckData = StructureBiomeCheck.getBiomeCheckData(structureCheckData);
        if (biomeCheckData == null || !biomeCheckData.isEnabled()) {
            return true;
        }
        if (biomeSource instanceof CheckerboardColumnBiomeSource) {
            return true;
        }
        StructureData structureData = structure.structurify$getStructureData();
        if (structureData == null) {
            return true;
        }
        GenerationStep.Decoration structureStep = structureData.getStep();
        if (structureStep != GenerationStep.Decoration.SURFACE_STRUCTURES && structureStep != GenerationStep.Decoration.LOCAL_MODIFICATIONS) {
            return true;
        }
        boolean isOceanStructure = structure.structurify$getStructureBiomes().m_203614_().map(h -> h.m_203543_().orElse(null)).anyMatch(k -> k != null && BiomeUtil.getOceanBiomes().contains(k));
        if (isOceanStructure) {
            return true;
        }
        boolean biomeCheckResult = StructureBiomeCheck.checkBiomes(structureCheckData, biomeCheckData, biomeSource, randomState);
        return biomeCheckResult;
    }

    private static boolean checkFlatness(StructureCheckData structureCheckData, ChunkGenerator chunkGenerator, LevelHeightAccessor heightAccessor, RandomState randomState) {
        StructurifyStructure structure = structureCheckData.getStructure();
        FlatnessCheckData flatnessCheckData = StructureFlatnessCheck.getFlatnessCheckData(structureCheckData);
        if (flatnessCheckData == null || !flatnessCheckData.isEnabled()) {
            return true;
        }
        StructureData structureData = structure.structurify$getStructureData();
        if (structureData == null) {
            return true;
        }
        GenerationStep.Decoration structureStep = structureData.getStep();
        if (structureStep != GenerationStep.Decoration.SURFACE_STRUCTURES && structureStep != GenerationStep.Decoration.LOCAL_MODIFICATIONS) {
            return true;
        }
        boolean isOceanStructure = structure.structurify$getStructureBiomes().m_203614_().map(h -> h.m_203543_().orElse(null)).anyMatch(k -> k != null && BiomeUtil.getOceanBiomes().contains(k));
        if (isOceanStructure) {
            return true;
        }
        boolean flatnessCheckResult = StructureFlatnessCheck.checkFlatness(structureCheckData, flatnessCheckData, chunkGenerator, heightAccessor, randomState);
        return flatnessCheckResult;
    }

    private static boolean checkOverlap(StructureCheckData structureCheckData, ChunkGenerator chunkGenerator) {
        if (!Structurify.getConfig().preventStructureOverlap) {
            return true;
        }
        boolean overlapCheckResult = StructureOverlapCheck.checkForOverlap(structureCheckData, (StructurifyChunkGenerator)chunkGenerator);
        return !overlapCheckResult;
    }
}

