/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class CommandAddlore {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"addlore").requires(source -> CommandAddlore.checkPermission(source))).then(Commands.m_82129_((String)"lore", (ArgumentType)StringArgumentType.string()).executes(CommandAddlore::addLore)));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opAddlore.get()).booleanValue()) {
            return source.m_6761_(2);
        }
        return true;
    }

    private static int addLore(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.m_81375_();
        String lore = StringArgumentType.getString(context, (String)"lore");
        ItemStack itemStack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (itemStack.m_41619_()) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.m_81352_((Component)Component.m_237113_((String)(warningColor + "You must hold an item in your main hand to add lore.")));
            return 0;
        }
        CompoundTag displayTag = itemStack.m_41698_("display");
        ListTag loreList = displayTag.m_128425_("Lore", 9) ? displayTag.m_128437_("Lore", 8) : new ListTag();
        String loreFormatted = String.format("{\"text\":\"%s\",\"color\":\"gray\"}", lore);
        loreList.add((Object)StringTag.m_129297_((String)loreFormatted));
        displayTag.m_128365_("Lore", (Tag)loreList);
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        String playerColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.playername.get());
        source.m_243053_((Component)Component.m_237113_((String)(standardColor + "Added lore: " + playerColor + lore)));
        return 1;
    }
}

