/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CommandBack {
    private static final Map<UUID, BlockPos> lastPositions = new HashMap<UUID, BlockPos>();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"back").requires(source -> CommandBack.checkPermission(source))).executes(CommandBack::teleportBack));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opBack.get()).booleanValue()) {
            return source.m_6761_(2);
        }
        return true;
    }

    private static int teleportBack(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        UUID playerUUID = player.m_20148_();
        if (lastPositions.containsKey(playerUUID)) {
            BlockPos lastPos = lastPositions.get(playerUUID);
            player.m_6021_((double)lastPos.m_123341_(), (double)lastPos.m_123342_(), (double)lastPos.m_123343_());
            String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)(standardColor + "Teleported back to your last location.")));
        } else {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)(warningColor + "No last location found.")));
        }
        return 1;
    }

    @SubscribeEvent
    public static void onPlayerTeleport(CommandEvent event) {
        CommandSourceStack source;
        if ((event.getParseResults().getReader().getString().startsWith("/tp") || event.getParseResults().getReader().getString().startsWith("/warp") || event.getParseResults().getReader().getString().startsWith("/tpa") || event.getParseResults().getReader().getString().startsWith("/home")) && (source = (CommandSourceStack)event.getParseResults().getContext().getSource()).m_81373_() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)source.m_81373_();
            CommandBack.saveLastPosition(player);
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            CommandBack.saveLastPosition(player);
        }
    }

    private static void saveLastPosition(ServerPlayer player) {
        lastPositions.put(player.m_20148_(), player.m_20183_());
    }
}

