/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class CommandCleanh {
    private static final Map<ServerPlayer, ItemStack[]> hotbarUndoMap = new HashMap<ServerPlayer, ItemStack[]>();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"cleanh").requires(source -> CommandCleanh.checkPermission(source))).executes(CommandCleanh::cleanHotbarSelf)).then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.m_82967_((String[])((CommandSourceStack)context.getSource()).m_81377_().m_7641_(), (SuggestionsBuilder)builder)).executes(context -> CommandCleanh.cleanHotbarOther((CommandContext<CommandSourceStack>)context, Collections.singletonList(StringArgumentType.getString((CommandContext)context, (String)"player"))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"cleanhundo").requires(source -> CommandCleanh.checkPermission(source))).executes(CommandCleanh::undoHotbarSelf)).then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.m_82967_((String[])((CommandSourceStack)context.getSource()).m_81377_().m_7641_(), (SuggestionsBuilder)builder)).executes(context -> CommandCleanh.undoHotbarOther((CommandContext<CommandSourceStack>)context, Collections.singletonList(StringArgumentType.getString((CommandContext)context, (String)"player"))))));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opCleanh.get()).booleanValue()) {
            return source.m_6761_(2);
        }
        return true;
    }

    private static int cleanHotbarSelf(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        CommandCleanh.saveHotbar(player);
        CommandCleanh.cleanHotbar(player);
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)(standardColor + "Cleared your hotbar.")));
        return 1;
    }

    private static int cleanHotbarOther(CommandContext<CommandSourceStack> context, Collection<String> targets) {
        for (String target : targets) {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11255_(target);
            if (player != null) {
                CommandCleanh.saveHotbar(player);
                CommandCleanh.cleanHotbar(player);
                String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
                String playerColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.playername.get());
                ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)(standardColor + "Cleared " + playerColor + target + standardColor + "'s hotbar.")));
                continue;
            }
            String errorColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)(errorColor + "Player " + target + " not found.")));
        }
        return 1;
    }

    private static void saveHotbar(ServerPlayer player) {
        ItemStack[] hotbarItems = new ItemStack[9];
        for (int i = 0; i < 9; ++i) {
            hotbarItems[i] = (ItemStack)player.m_150109_().f_35974_.get(i);
        }
        hotbarUndoMap.put(player, hotbarItems);
    }

    private static void cleanHotbar(ServerPlayer player) {
        Inventory inventory = player.m_150109_();
        for (int i = 0; i < 9; ++i) {
            inventory.f_35974_.set(i, (Object)ItemStack.f_41583_);
        }
        inventory.m_6596_();
    }

    private static int undoHotbarSelf(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        CommandCleanh.restoreHotbar(player);
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)(standardColor + "Your hotbar has been restored.")));
        return 1;
    }

    private static int undoHotbarOther(CommandContext<CommandSourceStack> context, Collection<String> targets) {
        for (String target : targets) {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11255_(target);
            if (player != null) {
                CommandCleanh.restoreHotbar(player);
                String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
                String playerColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.playername.get());
                ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)(standardColor + "Restored " + playerColor + target + standardColor + "'s hotbar.")));
                continue;
            }
            String errorColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)(errorColor + "Player " + target + " not found.")));
        }
        return 1;
    }

    private static void restoreHotbar(ServerPlayer player) {
        ItemStack[] savedHotbar = hotbarUndoMap.get(player);
        if (savedHotbar != null) {
            Inventory inventory = player.m_150109_();
            for (int i = 0; i < savedHotbar.length; ++i) {
                inventory.f_35974_.set(i, (Object)savedHotbar[i]);
            }
            inventory.m_6596_();
        }
    }
}

