/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.PlayerEnderChestContainer;

public class CommandEc {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ec").requires(source -> CommandEc.checkPermission(source))).executes(CommandEc::openOwnEnderChest)).then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.m_82970_((Iterable)((CommandSourceStack)context.getSource()).m_5982_(), (SuggestionsBuilder)builder)).executes(CommandEc::openOtherEnderChest)));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opEc.get()).booleanValue()) {
            return source.m_6761_(2);
        }
        return true;
    }

    private static int openOwnEnderChest(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.m_81375_();
        CommandEc.openEnderChest(player, player);
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        source.m_243053_((Component)Component.m_237113_((String)(standardColor + "Opened your EnderChest.")));
        return 1;
    }

    private static int openOtherEnderChest(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.m_81375_();
        String playerName = StringArgumentType.getString(context, (String)"player");
        ServerLevel world = source.m_81372_();
        ServerPlayer targetPlayer = world.m_7654_().m_6846_().m_11255_(playerName);
        if (targetPlayer != null) {
            CommandEc.openEnderChest(player, targetPlayer);
            String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
            source.m_243053_((Component)Component.m_237113_((String)(standardColor + "Opened EnderChest of " + playerName + ".")));
        } else {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.m_81352_((Component)Component.m_237113_((String)(warningColor + "Player " + playerName + " not found.")));
        }
        return 1;
    }

    private static void openEnderChest(ServerPlayer player, ServerPlayer targetPlayer) {
        final PlayerEnderChestContainer enderChest = targetPlayer.m_36327_();
        player.m_5893_(new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)"Ender Chest");
            }

            public ChestMenu createMenu(int id, Inventory playerInventory, Player playerEntity) {
                return ChestMenu.m_39237_((int)id, (Inventory)playerInventory, (Container)enderChest);
            }
        });
    }
}

