/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.server.ServerLifecycleHooks;

public class CommandEco {
    private static final SuggestionProvider<CommandSourceStack> PLAYER_NAME_PROVIDER = (context, builder) -> SharedSuggestionProvider.m_82967_((String[])ServerLifecycleHooks.getCurrentServer().m_7641_(), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"eco").requires(source -> CommandEco.checkPermission(source))).then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"playername", (ArgumentType)StringArgumentType.string()).suggests(PLAYER_NAME_PROVIDER).executes(context -> CommandEco.getEco((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"playername")))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"playername", (ArgumentType)StringArgumentType.string()).suggests(PLAYER_NAME_PROVIDER).then(Commands.m_82129_((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> CommandEco.setEco((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"playername"), DoubleArgumentType.getDouble((CommandContext)context, (String)"amount"))))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"playername", (ArgumentType)StringArgumentType.string()).suggests(PLAYER_NAME_PROVIDER).then(Commands.m_82129_((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> CommandEco.addEco((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"playername"), DoubleArgumentType.getDouble((CommandContext)context, (String)"amount"))))))).then(Commands.m_82127_((String)"take").then(Commands.m_82129_((String)"playername", (ArgumentType)StringArgumentType.string()).suggests(PLAYER_NAME_PROVIDER).then(Commands.m_82129_((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> CommandEco.takeEco((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"playername"), DoubleArgumentType.getDouble((CommandContext)context, (String)"amount")))))));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opBankSystem.get()).booleanValue()) {
            return source.m_6761_(2);
        }
        return true;
    }

    private static int getEco(CommandContext<CommandSourceStack> context, String playerName) {
        ServerPlayer player = CommandEco.getPlayerByName(playerName);
        if (player == null) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)(warningColor + "Player not found: " + playerName)));
            return 0;
        }
        double balance = CommandEco.getBankBalance(player.m_20148_());
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        String playerColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.playername.get());
        String senderColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.sendername.get());
        ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)(standardColor + "The balance of " + playerColor + playerName + standardColor + " is: " + senderColor + balance)));
        return 1;
    }

    private static int setEco(CommandContext<CommandSourceStack> context, String playerName, double amount) {
        ServerPlayer player = CommandEco.getPlayerByName(playerName);
        if (player == null) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)(warningColor + "Player not found: " + playerName)));
            return 0;
        }
        CommandEco.setBankBalance(player.m_20148_(), amount);
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        String playerColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.playername.get());
        String senderColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.sendername.get());
        ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)(standardColor + "The balance of " + playerColor + playerName + standardColor + " is: " + senderColor + amount)));
        return 1;
    }

    private static int addEco(CommandContext<CommandSourceStack> context, String playerName, double amount) {
        ServerPlayer player = CommandEco.getPlayerByName(playerName);
        if (player == null) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)(warningColor + "Player not found: " + playerName)));
            return 0;
        }
        double currentBalance = CommandEco.getBankBalance(player.m_20148_());
        double newBalance = currentBalance + amount;
        CommandEco.setBankBalance(player.m_20148_(), newBalance);
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        String playerColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.playername.get());
        String senderColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.sendername.get());
        ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)(senderColor + amount + standardColor + " has been added to the balance of " + playerColor + playerName + standardColor + ". New balance: " + senderColor + newBalance)));
        return 1;
    }

    private static int takeEco(CommandContext<CommandSourceStack> context, String playerName, double amount) {
        ServerPlayer player = CommandEco.getPlayerByName(playerName);
        if (player == null) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)(warningColor + "Player not found: " + playerName)));
            return 0;
        }
        double currentBalance = CommandEco.getBankBalance(player.m_20148_());
        double newBalance = currentBalance - amount;
        if (newBalance < 0.0) {
            newBalance = 0.0;
        }
        CommandEco.setBankBalance(player.m_20148_(), newBalance);
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        String playerColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.playername.get());
        String senderColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.sendername.get());
        ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)(senderColor + amount + standardColor + " has been deducted from the balance of " + playerColor + playerName + standardColor + ". New balance: " + senderColor + newBalance)));
        return 1;
    }

    private static ServerPlayer getPlayerByName(String playerName) {
        return ServerLifecycleHooks.getCurrentServer().m_6846_().m_11255_(playerName);
    }

    private static double getBankBalance(UUID uuid) {
        block7: {
            double d;
            Path bankFile = CommandEco.getBankFile(uuid);
            if (!Files.exists(bankFile, new LinkOption[0])) break block7;
            FileReader reader = new FileReader(bankFile.toFile());
            try {
                d = Double.parseDouble(new String(Files.readAllBytes(bankFile)));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            reader.close();
            return d;
        }
        return 0.0;
    }

    private static void setBankBalance(UUID uuid, double amount) {
        try {
            Path bankFile = CommandEco.getBankFile(uuid);
            try (FileWriter writer = new FileWriter(bankFile.toFile());){
                writer.write(String.valueOf(amount));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Path getBankFile(UUID uuid) {
        File worldFolder = ServerLifecycleHooks.getCurrentServer().m_129843_(LevelResource.f_78182_).toFile();
        File modFolder = new File(worldFolder, "sarosessentialsmod/bank");
        if (!modFolder.exists()) {
            modFolder.mkdirs();
        }
        return new File(modFolder, uuid.toString() + ".bank").toPath();
    }
}

