/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.food.FoodData;
import net.minecraftforge.server.ServerLifecycleHooks;

public class CommandFeed {
    private static final SuggestionProvider<CommandSourceStack> PLAYER_NAME_PROVIDER = (context, builder) -> SharedSuggestionProvider.m_82967_((String[])ServerLifecycleHooks.getCurrentServer().m_7641_(), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"feed").requires(source -> CommandFeed.checkPermission(source))).executes(CommandFeed::feedSelf)).then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.string()).suggests(PLAYER_NAME_PROVIDER).executes(CommandFeed::feedPlayer)));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opFeed.get()).booleanValue()) {
            return source.m_6761_(2);
        }
        return true;
    }

    private static int feedSelf(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.m_81375_();
        CommandFeed.feedPlayer(player);
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        source.m_243053_((Component)Component.m_237113_((String)(standardColor + "Your hunger has been refilled.")));
        return 1;
    }

    private static int feedPlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String playerName = StringArgumentType.getString(context, (String)"player");
        ServerPlayer targetPlayer = source.m_81377_().m_6846_().m_11255_(playerName);
        if (targetPlayer != null) {
            CommandFeed.feedPlayer(targetPlayer);
            String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
            source.m_243053_((Component)Component.m_237113_((String)(standardColor + "Refilled hunger for " + playerName + ".")));
        } else {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.m_81352_((Component)Component.m_237113_((String)(warningColor + "Player " + playerName + " not found.")));
        }
        return 1;
    }

    private static void feedPlayer(ServerPlayer player) {
        FoodData foodData = player.m_36324_();
        foodData.m_38705_(20);
    }
}

