/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.server.ServerLifecycleHooks;

public class CommandFly {
    private static final SuggestionProvider<CommandSourceStack> PLAYER_NAME_PROVIDER = (context, builder) -> SharedSuggestionProvider.m_82967_((String[])ServerLifecycleHooks.getCurrentServer().m_7641_(), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"fly").requires(source -> CommandFly.checkPermission(source))).executes(CommandFly::toggleOwnFlyMode)).then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.string()).suggests(PLAYER_NAME_PROVIDER).executes(CommandFly::togglePlayerFlyMode)));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opFly.get()).booleanValue()) {
            return source.m_6761_(2);
        }
        return true;
    }

    private static int toggleOwnFlyMode(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.m_81375_();
        CommandFly.toggleFlyMode(player);
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        source.m_243053_((Component)Component.m_237113_((String)(standardColor + "Toggled fly mode for yourself.")));
        return 1;
    }

    private static int togglePlayerFlyMode(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String playerName = StringArgumentType.getString(context, (String)"player");
        ServerPlayer targetPlayer = source.m_81377_().m_6846_().m_11255_(playerName);
        if (targetPlayer != null) {
            CommandFly.toggleFlyMode(targetPlayer);
            String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
            source.m_243053_((Component)Component.m_237113_((String)(standardColor + "Toggled fly mode for " + playerName + ".")));
        } else {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.m_81352_((Component)Component.m_237113_((String)(warningColor + "Player " + playerName + " not found.")));
        }
        return 1;
    }

    private static void toggleFlyMode(ServerPlayer player) {
        boolean isFlying = player.m_150110_().f_35935_;
        player.m_150110_().f_35935_ = !isFlying;
        player.m_150110_().f_35936_ = !isFlying;
        player.m_6885_();
        String message = !isFlying ? "Fly mode enabled." : "Fly mode disabled.";
        player.m_213846_((Component)Component.m_237113_((String)message));
    }
}

