/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameType;
import net.minecraftforge.server.ServerLifecycleHooks;

public class CommandGm {
    private static final SuggestionProvider<CommandSourceStack> GAME_MODES = (context, builder) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"0", "1", "2", "3"}, (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> PLAYER_NAME_PROVIDER = (context, builder) -> SharedSuggestionProvider.m_82967_((String[])ServerLifecycleHooks.getCurrentServer().m_7641_(), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"gm").requires(source -> CommandGm.checkPermission(source))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"mode", (ArgumentType)IntegerArgumentType.integer((int)0, (int)3)).suggests(GAME_MODES).executes(context -> CommandGm.changeGameMode((CommandContext<CommandSourceStack>)context, null))).then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.string()).suggests(PLAYER_NAME_PROVIDER).executes(context -> CommandGm.changeGameMode((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"player"))))));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opGm.get()).booleanValue()) {
            return source.m_6761_(2);
        }
        return true;
    }

    private static int changeGameMode(CommandContext<CommandSourceStack> context, String playerName) throws CommandSyntaxException {
        ServerPlayer targetPlayer;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        int mode = IntegerArgumentType.getInteger(context, (String)"mode");
        GameType gameType = GameType.m_46393_((int)mode);
        boolean isSelfChange = false;
        if (playerName != null) {
            targetPlayer = source.m_81377_().m_6846_().m_11255_(playerName);
            if (targetPlayer == null) {
                String errorColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                source.m_81352_((Component)Component.m_237113_((String)(errorColor + "Player " + playerName + " not found.")));
                return 1;
            }
        } else {
            targetPlayer = source.m_81375_();
            isSelfChange = true;
        }
        targetPlayer.m_143403_(gameType);
        String successColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.success.get());
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        String playerColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.playername.get());
        if (isSelfChange) {
            source.m_243053_((Component)Component.m_237113_((String)(standardColor + "Changed your game mode to " + successColor + gameType.m_46405_())));
        } else {
            source.m_243053_((Component)Component.m_237113_((String)(standardColor + "Changed game mode to " + successColor + gameType.m_46405_() + standardColor + " for " + playerColor + targetPlayer.m_7755_().getString())));
        }
        return 1;
    }
}

