/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class CommandRename {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"rename").requires(source -> CommandRename.checkPermission(source))).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(CommandRename::renameItem)));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opRename.get()).booleanValue()) {
            return source.m_6761_(2);
        }
        return true;
    }

    private static int renameItem(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.m_81375_();
        String newName = StringArgumentType.getString(context, (String)"name");
        ItemStack itemStack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (itemStack.m_41619_()) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.m_81352_((Component)Component.m_237113_((String)(warningColor + "You must hold an item in your main hand to rename it.")));
            return 0;
        }
        itemStack.m_41714_((Component)Component.m_237113_((String)newName));
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        String playernameColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.playername.get());
        source.m_243053_((Component)Component.m_237113_((String)(standardColor + "Renamed item to: " + playernameColor + newName)));
        return 1;
    }
}

