/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class CommandSetlore {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"setlore").requires(source -> CommandSetlore.checkPermission(source))).then(Commands.m_82129_((String)"line", (ArgumentType)IntegerArgumentType.integer((int)0)).suggests(CommandSetlore.suggestLines()).then(Commands.m_82129_((String)"lore", (ArgumentType)StringArgumentType.string()).executes(CommandSetlore::setLore))));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opSetlore.get()).booleanValue()) {
            return source.m_6761_(2);
        }
        return true;
    }

    private static SuggestionProvider<CommandSourceStack> suggestLines() {
        return (context, builder) -> {
            ServerPlayer player;
            try {
                player = ((CommandSourceStack)context.getSource()).m_81375_();
            }
            catch (CommandSyntaxException e) {
                return CompletableFuture.completedFuture(builder.build());
            }
            ItemStack itemStack = player.m_21120_(InteractionHand.MAIN_HAND);
            if (itemStack.m_41619_() || !itemStack.m_41782_() || !itemStack.m_41783_().m_128441_("display") || !itemStack.m_41783_().m_128469_("display").m_128425_("Lore", 9)) {
                return CompletableFuture.completedFuture(builder.build());
            }
            ListTag loreList = itemStack.m_41783_().m_128469_("display").m_128437_("Lore", 8);
            for (int i = 0; i < loreList.size(); ++i) {
                builder.suggest(i);
            }
            return CompletableFuture.completedFuture(builder.build());
        };
    }

    private static int setLore(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.m_81375_();
        int line = IntegerArgumentType.getInteger(context, (String)"line");
        String newLore = StringArgumentType.getString(context, (String)"lore");
        ItemStack itemStack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (itemStack.m_41619_()) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.m_81352_((Component)Component.m_237113_((String)(warningColor + "You must hold an item in your main hand to set lore.")));
            return 0;
        }
        CompoundTag displayTag = itemStack.m_41698_("display");
        if (!displayTag.m_128425_("Lore", 9)) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.m_81352_((Component)Component.m_237113_((String)(warningColor + "This item has no lore to edit use /addlore.")));
            return 0;
        }
        ListTag loreList = displayTag.m_128437_("Lore", 8);
        if (line < 0 || line >= loreList.size()) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.m_81352_((Component)Component.m_237113_((String)(warningColor + "Invalid line number use /addlore.")));
            return 0;
        }
        String loreFormatted = String.format("{\"text\":\"%s\",\"color\":\"gray\"}", newLore);
        loreList.set(line, (Tag)StringTag.m_129297_((String)loreFormatted));
        displayTag.m_128365_("Lore", (Tag)loreList);
        String standard = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        String playername = Dateiverwaltung.getColorCode((String)Dateiverwaltung.playername.get());
        String success = Dateiverwaltung.getColorCode((String)Dateiverwaltung.success.get());
        source.m_243053_((Component)Component.m_237113_((String)(standard + "Lore line " + playername + line + standard + " set to: " + success + newLore)));
        return 1;
    }
}

