/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class CommandSkull {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"skull").requires(source -> CommandSkull.checkPermission(source))).executes(CommandSkull::giveOwnHead)).then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.m_82970_((Iterable)((CommandSourceStack)context.getSource()).m_5982_(), (SuggestionsBuilder)builder)).executes(CommandSkull::givePlayerHead)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"head").requires(source -> CommandSkull.checkPermission(source))).executes(CommandSkull::giveOwnHead)).then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.m_82970_((Iterable)((CommandSourceStack)context.getSource()).m_5982_(), (SuggestionsBuilder)builder)).executes(CommandSkull::givePlayerHead)));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opSkull.get()).booleanValue()) {
            return source.m_6761_(2);
        }
        return true;
    }

    private static int giveOwnHead(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.m_81375_();
        CommandSkull.givePlayerHead(player, player.m_36316_().getName());
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        source.m_243053_((Component)Component.m_237113_((String)(standardColor + "Given your head.")));
        return 1;
    }

    private static int givePlayerHead(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.m_81375_();
        String playerName = StringArgumentType.getString(context, (String)"player");
        CommandSkull.givePlayerHead(player, playerName);
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        source.m_243053_((Component)Component.m_237113_((String)(standardColor + "Given head of " + playerName + ".")));
        return 1;
    }

    private static void givePlayerHead(ServerPlayer player, String playerName) {
        ItemStack skull = new ItemStack((ItemLike)Items.f_42680_);
        CompoundTag tag = skull.m_41784_();
        CompoundTag skullOwnerTag = new CompoundTag();
        skullOwnerTag.m_128359_("Name", playerName);
        tag.m_128365_("SkullOwner", (Tag)skullOwnerTag);
        skull.m_41751_(tag);
        player.m_36356_(skull);
    }
}

