/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.google.gson.Gson;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.sarocesch.sarosessentialsmod.SpawnPoint;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CommandSpawn {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"spawn").executes(context -> CommandSpawn.teleportToSpawn((CommandSourceStack)context.getSource())));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opSpawn.get()).booleanValue()) {
            return source.m_6761_(2);
        }
        return true;
    }

    private static int teleportToSpawn(CommandSourceStack source) {
        try {
            ServerPlayer player = source.m_81375_();
            SpawnPoint spawnPoint = CommandSpawn.loadSpawnPoint(source);
            if (spawnPoint == null) {
                String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                source.m_81352_((Component)Component.m_237113_((String)(warningColor + "No spawn point set!")));
                return 0;
            }
            ServerLevel world = source.m_81377_().m_129880_(ServerLevel.f_46428_);
            if (world == null || !world.m_46472_().m_135782_().toString().equals(spawnPoint.dimension)) {
                String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                source.m_81352_((Component)Component.m_237113_((String)(warningColor + "Invalid spawn point dimension!")));
                return 0;
            }
            player.m_8999_(world, spawnPoint.position.f_82479_, spawnPoint.position.f_82480_, spawnPoint.position.f_82481_, spawnPoint.rotation.f_82471_, spawnPoint.rotation.f_82470_);
            String successColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.success.get());
            source.m_243053_((Component)Component.m_237113_((String)(successColor + "Teleported to spawn point!")));
            return 1;
        }
        catch (Exception e) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.m_81352_((Component)Component.m_237113_((String)(warningColor + "Failed to teleport to spawn point: " + e.getMessage())));
            return 0;
        }
    }

    private static SpawnPoint loadSpawnPoint(CommandSourceStack source) throws IOException {
        File worldFolder = source.m_81377_().m_129843_(LevelResource.f_78182_).resolve("sarosessentialsmod").toFile();
        File spawnFile = new File(worldFolder, "spawn.info");
        if (!spawnFile.exists()) {
            return null;
        }
        Gson gson = new Gson();
        try (FileReader reader = new FileReader(spawnFile);){
            SpawnPoint spawnPoint = (SpawnPoint)gson.fromJson((Reader)reader, SpawnPoint.class);
            return spawnPoint;
        }
    }
}

