/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class CommandTphere {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tphere").requires(source -> CommandTphere.checkPermission(source))).then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).suggests(CommandTphere::suggestPlayers).executes(CommandTphere::execute)));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opTphere.get()).booleanValue()) {
            return source.m_6761_(2);
        }
        return true;
    }

    private static CompletableFuture<Suggestions> suggestPlayers(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        List players = ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11314_();
        for (ServerPlayer player : players) {
            builder.suggest(player.m_7755_().getString());
        }
        return builder.buildFuture();
    }

    private static int execute(CommandContext<CommandSourceStack> context) {
        try {
            ServerPlayer playerExecuting = ((CommandSourceStack)context.getSource()).m_81375_();
            String playerName = StringArgumentType.getString(context, (String)"player");
            ServerPlayer playerToTeleport = ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11255_(playerName);
            if (playerToTeleport == null) {
                String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)(warningColor + "Player not found.")));
                return 0;
            }
            CommandTphere.teleportPlayer(playerExecuting, playerToTeleport);
            String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
            String playerColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.playername.get());
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)(standardColor + "Teleported " + playerColor + playerName + standardColor + " to you.")));
            return 1;
        }
        catch (CommandSyntaxException e) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)(warningColor + "You must be a player to use this command.")));
            return 0;
        }
    }

    private static void teleportPlayer(ServerPlayer targetPlayer, ServerPlayer playerToTeleport) {
        ServerLevel targetWorld = targetPlayer.m_9236_();
        if (playerToTeleport.m_9236_() != targetWorld) {
            playerToTeleport.m_5489_(targetWorld);
        }
        playerToTeleport.m_8999_(targetWorld, targetPlayer.m_20185_(), targetPlayer.m_20186_(), targetPlayer.m_20189_(), targetPlayer.m_146908_(), targetPlayer.m_146909_());
    }
}

