/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class CommandUnbreakable {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"unbreakable").requires(source -> CommandUnbreakable.checkPermission(source))).executes(context -> CommandUnbreakable.makeItemUnbreakable((CommandSourceStack)context.getSource())));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opUnbreakable.get()).booleanValue()) {
            return source.m_6761_(2);
        }
        return true;
    }

    private static int makeItemUnbreakable(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player = source.m_81375_();
        ItemStack itemStack = player.m_21205_();
        if (itemStack.m_41619_()) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.m_81352_((Component)Component.m_237113_((String)(warningColor + "You must hold an item in your hand to make it unbreakable.")));
            return 0;
        }
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128379_("Unbreakable", true);
        itemStack.m_41751_(tag);
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        source.m_243053_((Component)Component.m_237113_((String)(standardColor + "The item in your hand is now unbreakable.")));
        return 1;
    }
}

