/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CommandVanish {
    private static final Map<String, Boolean> vanishedPlayers = new HashMap<String, Boolean>();
    private static final SuggestionProvider<CommandSourceStack> PLAYER_SUGGESTIONS = (context, builder) -> SharedSuggestionProvider.m_82967_((String[])((CommandSourceStack)context.getSource()).m_81377_().m_7641_(), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"vanish").requires(source -> CommandVanish.checkPermission(source))).then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.string()).suggests(PLAYER_SUGGESTIONS).executes(context -> CommandVanish.toggleVanish((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"player"))))).executes(context -> CommandVanish.toggleVanish((CommandContext<CommandSourceStack>)context, ((CommandSourceStack)context.getSource()).m_81368_())));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"v").requires(source -> CommandVanish.checkPermission(source))).then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.string()).suggests(PLAYER_SUGGESTIONS).executes(context -> CommandVanish.toggleVanish((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"player"))))).executes(context -> CommandVanish.toggleVanish((CommandContext<CommandSourceStack>)context, ((CommandSourceStack)context.getSource()).m_81368_())));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opVanish.get()).booleanValue()) {
            return source.m_6761_(2);
        }
        return true;
    }

    private static int toggleVanish(CommandContext<CommandSourceStack> context, String playerName) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11255_(playerName);
        if (player == null) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)(warningColor + "Player not found")));
            return 0;
        }
        boolean isVanished = vanishedPlayers.getOrDefault(playerName, false);
        if (isVanished) {
            player.m_6842_(false);
            vanishedPlayers.put(playerName, false);
            String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)(standardColor + playerName + " is now visible")));
        } else {
            player.m_6842_(true);
            vanishedPlayers.put(playerName, true);
            String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)(standardColor + playerName + " is now invisible")));
        }
        return 1;
    }
}

