/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.event;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BankInit {
    private static final String FOLDER_NAME = "sarosessentialsmod/bank";

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            BankInit.createBankFile(player);
        }
    }

    private static void createBankFile(ServerPlayer player) {
        File bankFile = BankInit.getBankFile(player);
        if (!bankFile.exists()) {
            try {
                bankFile.createNewFile();
                try (FileWriter writer = new FileWriter(bankFile);){
                    writer.write("0");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static File getBankFile(ServerPlayer player) {
        File worldFolder = player.m_20194_().m_129843_(LevelResource.f_78182_).toFile();
        File modFolder = new File(worldFolder, FOLDER_NAME);
        if (!modFolder.exists()) {
            modFolder.mkdirs();
        }
        return new File(modFolder, player.m_20148_().toString() + ".bank");
    }
}

