/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.listener;

import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class JoinLeaveListener {
    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        MinecraftServer server = player.m_20194_();
        if (server == null) {
            return;
        }
        boolean isFirstJoin = player.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12989_)) == 0;
        String message = null;
        if (isFirstJoin && ((Boolean)Dateiverwaltung.customFirstJoinMessageEnabled.get()).booleanValue()) {
            message = (String)Dateiverwaltung.customFirstJoinMessage.get();
        } else if (((Boolean)Dateiverwaltung.customJoinMessageEnabled.get()).booleanValue()) {
            message = (String)Dateiverwaltung.customJoinMessage.get();
        }
        if (message != null) {
            JoinLeaveListener.sendFormattedMessage(server, player, message);
        }
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        MinecraftServer server = player.m_20194_();
        if (server == null) {
            return;
        }
        if (((Boolean)Dateiverwaltung.customLeaveMessageEnabled.get()).booleanValue()) {
            String message = (String)Dateiverwaltung.customLeaveMessage.get();
            JoinLeaveListener.sendFormattedMessage(server, player, message);
        }
    }

    @SubscribeEvent
    public static void onServerChat(ServerChatEvent event) {
        boolean isLeaveMessage;
        boolean cancelJoin = (Boolean)Dateiverwaltung.customJoinMessageEnabled.get();
        boolean cancelLeave = (Boolean)Dateiverwaltung.customLeaveMessageEnabled.get();
        if (!cancelJoin && !cancelLeave) {
            return;
        }
        String rawMessage = event.getMessage().getString();
        boolean isJoinMessage = rawMessage.contains("joined the game") && cancelJoin;
        boolean bl = isLeaveMessage = rawMessage.contains("left the game") && cancelLeave;
        if (isJoinMessage || isLeaveMessage) {
            event.setCanceled(true);
        }
    }

    private static void sendFormattedMessage(MinecraftServer server, ServerPlayer player, String message) {
        String formattedMessage = message.replace("{PLAYER}", player.m_5446_().getString());
        server.m_6846_().m_240416_((Component)Component.m_237113_((String)formattedMessage), false);
    }
}

