/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class CommandClear {
    private static final Map<ServerPlayer, ItemStack[]> undoMap = new HashMap<ServerPlayer, ItemStack[]>();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"clear").requires(source -> CommandClear.checkPermission(source))).executes(CommandClear::clearSelf)).then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.m_82970_((Iterable)((CommandSourceStack)context.getSource()).m_5982_(), (SuggestionsBuilder)builder)).executes(CommandClear::clearPlayer)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"clearundo").requires(source -> CommandClear.checkPermission(source))).executes(CommandClear::undoSelf)).then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.m_82970_((Iterable)((CommandSourceStack)context.getSource()).m_5982_(), (SuggestionsBuilder)builder)).executes(CommandClear::undoPlayer)));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opClear.get()).booleanValue()) {
            return source.m_6761_(2);
        }
        return true;
    }

    private static int clearSelf(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.m_81375_();
        CommandClear.saveInventory(player);
        CommandClear.clearPlayerInventory(player);
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        source.m_243053_((Component)Component.m_237113_((String)(standardColor + "Your inventory has been cleared.")));
        return 1;
    }

    private static int clearPlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String playerName = StringArgumentType.getString(context, (String)"player");
        ServerPlayer targetPlayer = source.m_81377_().m_6846_().m_11255_(playerName);
        if (targetPlayer != null) {
            CommandClear.saveInventory(targetPlayer);
            CommandClear.clearPlayerInventory(targetPlayer);
            String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
            source.m_243053_((Component)Component.m_237113_((String)(standardColor + "Player " + playerName + "'s inventory has been cleared.")));
        } else {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.m_81352_((Component)Component.m_237113_((String)(warningColor + "Player " + playerName + " not found.")));
        }
        return 1;
    }

    private static void saveInventory(ServerPlayer player) {
        undoMap.put(player, (ItemStack[])player.m_150109_().f_35974_.toArray((Object[])new ItemStack[0]));
    }

    private static void clearPlayerInventory(ServerPlayer player) {
        player.m_150109_().m_6211_();
    }

    private static int undoSelf(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.m_81375_();
        CommandClear.restoreInventory(player);
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        source.m_243053_((Component)Component.m_237113_((String)(standardColor + "Your inventory has been restored.")));
        return 1;
    }

    private static int undoPlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String playerName = StringArgumentType.getString(context, (String)"player");
        ServerPlayer targetPlayer = source.m_81377_().m_6846_().m_11255_(playerName);
        if (targetPlayer != null) {
            CommandClear.restoreInventory(targetPlayer);
            String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
            source.m_243053_((Component)Component.m_237113_((String)(standardColor + "Player " + playerName + "'s inventory has been restored.")));
        } else {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.m_81352_((Component)Component.m_237113_((String)(warningColor + "Player " + playerName + " not found.")));
        }
        return 1;
    }

    private static void restoreInventory(ServerPlayer player) {
        ItemStack[] savedInventory = undoMap.get(player);
        if (savedInventory != null) {
            player.m_150109_().f_35974_.clear();
            for (int i = 0; i < savedInventory.length; ++i) {
                player.m_150109_().f_35974_.set(i, (Object)savedInventory[i]);
            }
        }
    }
}

