/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class CommandHome {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"home").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).suggests(CommandHome::suggestHomes).executes(ctx -> CommandHome.teleportHome((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name"))))).executes(ctx -> CommandHome.teleportHome((CommandContext<CommandSourceStack>)ctx, "default")));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sethome").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> CommandHome.setHome((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name"))))).executes(ctx -> CommandHome.setHome((CommandContext<CommandSourceStack>)ctx, "default")));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"delhome").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).suggests(CommandHome::suggestHomes).executes(ctx -> CommandHome.deleteHome((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name")))));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"listhomes").executes(CommandHome::listHomes));
    }

    private static CompletableFuture<Suggestions> suggestHomes(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        ServerPlayer player;
        try {
            player = ((CommandSourceStack)context.getSource()).m_81375_();
        }
        catch (Exception e) {
            return SharedSuggestionProvider.m_82970_(Collections.emptyList(), (SuggestionsBuilder)builder);
        }
        ServerLevel level = player.m_9236_();
        Set<String> homes = HomeData.get(level).getPlayerHomes(player.m_20148_());
        return SharedSuggestionProvider.m_82970_(homes, (SuggestionsBuilder)builder);
    }

    private static int setHome(CommandContext<CommandSourceStack> context, String name) {
        ServerPlayer player;
        try {
            player = ((CommandSourceStack)context.getSource()).m_81375_();
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Nur Spieler k\u00f6nnen Homes setzen!"));
            return 0;
        }
        ServerLevel level = player.m_9236_();
        HomeData data = HomeData.get(level);
        data.setHome(player.m_20148_(), name, player.m_20183_(), (ResourceKey<Level>)level.m_46472_());
        data.m_77762_();
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)("Home '" + name + "' gesetzt.")), false);
        return 1;
    }

    private static int teleportHome(CommandContext<CommandSourceStack> context, String name) {
        ServerPlayer player;
        try {
            player = ((CommandSourceStack)context.getSource()).m_81375_();
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Nur Spieler k\u00f6nnen Homes nutzen!"));
            return 0;
        }
        ServerLevel level = player.m_9236_();
        HomeData data = HomeData.get(level);
        HomeData.HomePosition pos = data.getHome(player.m_20148_(), name);
        if (pos == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Home '" + name + "' existiert nicht.")));
            return 0;
        }
        MinecraftServer server = level.m_7654_();
        ServerLevel targetLevel = server.m_129880_(pos.dimension);
        if (targetLevel == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Ziel-Dimension nicht gefunden."));
            return 0;
        }
        player.m_8999_(targetLevel, (double)pos.pos.m_123341_() + 0.5, (double)pos.pos.m_123342_(), (double)pos.pos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)("Teleportiert zu '" + name + "'.")), false);
        return 1;
    }

    private static int deleteHome(CommandContext<CommandSourceStack> context, String name) {
        ServerPlayer player;
        try {
            player = ((CommandSourceStack)context.getSource()).m_81375_();
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Nur Spieler k\u00f6nnen Homes l\u00f6schen!"));
            return 0;
        }
        ServerLevel level = player.m_9236_();
        HomeData data = HomeData.get(level);
        if (data.deleteHome(player.m_20148_(), name)) {
            data.m_77762_();
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)("Home '" + name + "' gel\u00f6scht.")), false);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Home '" + name + "' existiert nicht.")));
        return 0;
    }

    private static int listHomes(CommandContext<CommandSourceStack> context) {
        ServerPlayer player;
        try {
            player = ((CommandSourceStack)context.getSource()).m_81375_();
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Nur Spieler k\u00f6nnen Homes auflisten!"));
            return 0;
        }
        ServerLevel level = player.m_9236_();
        HomeData data = HomeData.get(level);
        Set<String> homes = data.getPlayerHomes(player.m_20148_());
        if (homes.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)"Du hast keine Homes."), false);
        } else {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)("Deine Homes: " + String.join((CharSequence)", ", homes))), false);
        }
        return 1;
    }

    public static class HomeData
    extends SavedData {
        private static final String DATA_NAME = "sarosessentials_homes";
        private final Map<UUID, Map<String, HomePosition>> playerHomes = new HashMap<UUID, Map<String, HomePosition>>();

        public static HomeData get(ServerLevel level) {
            return (HomeData)level.m_8895_().m_164861_(HomeData::load, HomeData::new, DATA_NAME);
        }

        public static HomeData load(CompoundTag tag) {
            HomeData data = new HomeData();
            for (String uuidStr : tag.m_128431_()) {
                UUID uuid = UUID.fromString(uuidStr);
                CompoundTag playerTag = tag.m_128469_(uuidStr);
                HashMap<String, HomePosition> homes = new HashMap<String, HomePosition>();
                for (String homeName : playerTag.m_128431_()) {
                    CompoundTag homeTag = playerTag.m_128469_(homeName);
                    homes.put(homeName, HomePosition.fromTag(homeTag));
                }
                data.playerHomes.put(uuid, homes);
            }
            return data;
        }

        public CompoundTag m_7176_(CompoundTag tag) {
            for (Map.Entry<UUID, Map<String, HomePosition>> entry : this.playerHomes.entrySet()) {
                CompoundTag playerTag = new CompoundTag();
                for (Map.Entry<String, HomePosition> home : entry.getValue().entrySet()) {
                    playerTag.m_128365_(home.getKey(), (Tag)home.getValue().toTag());
                }
                tag.m_128365_(entry.getKey().toString(), (Tag)playerTag);
            }
            return tag;
        }

        public void setHome(UUID uuid, String name, BlockPos pos, ResourceKey<Level> dimension) {
            this.playerHomes.computeIfAbsent(uuid, k -> new HashMap()).put(name, new HomePosition(pos, dimension));
        }

        public boolean deleteHome(UUID uuid, String name) {
            Map<String, HomePosition> homes = this.playerHomes.get(uuid);
            return homes != null && homes.remove(name) != null;
        }

        public Set<String> getPlayerHomes(UUID uuid) {
            return this.playerHomes.getOrDefault(uuid, Collections.emptyMap()).keySet();
        }

        public HomePosition getHome(UUID uuid, String name) {
            Map<String, HomePosition> homes = this.playerHomes.get(uuid);
            return homes != null ? homes.get(name) : null;
        }

        public static class HomePosition {
            public final BlockPos pos;
            public final ResourceKey<Level> dimension;

            public HomePosition(BlockPos pos, ResourceKey<Level> dimension) {
                this.pos = pos;
                this.dimension = dimension;
            }

            public CompoundTag toTag() {
                CompoundTag tag = new CompoundTag();
                tag.m_128405_("x", this.pos.m_123341_());
                tag.m_128405_("y", this.pos.m_123342_());
                tag.m_128405_("z", this.pos.m_123343_());
                tag.m_128359_("dimension", this.dimension.m_135782_().toString());
                return tag;
            }

            public static HomePosition fromTag(CompoundTag tag) {
                BlockPos pos = new BlockPos(tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z"));
                ResourceKey dim = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(tag.m_128461_("dimension")));
                return new HomePosition(pos, (ResourceKey<Level>)dim);
            }
        }
    }
}

