/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.io.File;
import java.io.IOException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CommandInventory {
    private static final String FOLDER_NAME = "sarosessentialsmod";
    private static final String INVENTORIES_FOLDER_NAME = "inventorys";

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"inventory").requires(source -> CommandInventory.checkPermission(source))).then(Commands.m_82127_((String)"save").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> CommandInventory.saveInventory((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name")))))).then(Commands.m_82127_((String)"load").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            File inventoryFolder = CommandInventory.getInventoryFolder(((CommandSourceStack)context.getSource()).m_81377_().m_129843_(LevelResource.f_78182_).toFile());
            if (inventoryFolder.exists() && inventoryFolder.isDirectory()) {
                for (File file : inventoryFolder.listFiles()) {
                    if (!file.isFile() || !file.getName().endsWith(".inv")) continue;
                    builder.suggest(file.getName().replace(String.valueOf(player.m_20148_()) + "_", "").replace(".inv", ""));
                }
            }
            return builder.buildFuture();
        }).executes(context -> CommandInventory.loadInventory((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name")))))).then(Commands.m_82127_((String)"delete").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            File inventoryFolder = CommandInventory.getInventoryFolder(((CommandSourceStack)context.getSource()).m_81377_().m_129843_(LevelResource.f_78182_).toFile());
            if (inventoryFolder.exists() && inventoryFolder.isDirectory()) {
                for (File file : inventoryFolder.listFiles()) {
                    if (!file.isFile() || !file.getName().endsWith(".inv")) continue;
                    builder.suggest(file.getName().replace(String.valueOf(player.m_20148_()) + "_", "").replace(".inv", ""));
                }
            }
            return builder.buildFuture();
        }).executes(context -> CommandInventory.deleteInventory((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"))))));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opInventory.get()).booleanValue()) {
            return source.m_6761_(2);
        }
        return true;
    }

    private static int saveInventory(CommandSourceStack source, String name) {
        try {
            File file;
            ServerPlayer player = source.m_81375_();
            File inventoryFolder = CommandInventory.getInventoryFolder(source.m_81377_().m_129843_(LevelResource.f_78182_).toFile());
            if (!inventoryFolder.exists()) {
                inventoryFolder.mkdirs();
            }
            if ((file = new File(inventoryFolder, String.valueOf(player.m_20148_()) + "_" + name + ".inv")).exists()) {
                String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                source.m_81352_((Component)Component.m_237113_((String)(warningColor + "An inventory with this name already exists!")));
                return 0;
            }
            ListTag nbt = new ListTag();
            player.m_150109_().m_36026_(nbt);
            CompoundTag compoundNBT = new CompoundTag();
            compoundNBT.m_128365_("Inventory", (Tag)nbt);
            NbtIo.m_128944_((CompoundTag)compoundNBT, (File)file);
            String successColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.success.get());
            source.m_243053_((Component)Component.m_237113_((String)(successColor + "Inventory saved successfully!")));
            return 1;
        }
        catch (CommandSyntaxException e) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.m_81352_((Component)Component.m_237113_((String)(warningColor + "Failed to get player: " + e.getMessage())));
            return 0;
        }
        catch (IOException e) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.m_81352_((Component)Component.m_237113_((String)(warningColor + "Failed to save inventory: " + e.getMessage())));
            return 0;
        }
    }

    private static int loadInventory(CommandSourceStack source, String name) {
        try {
            ServerPlayer player = source.m_81375_();
            File inventoryFolder = CommandInventory.getInventoryFolder(source.m_81377_().m_129843_(LevelResource.f_78182_).toFile());
            File file = new File(inventoryFolder, String.valueOf(player.m_20148_()) + "_" + name + ".inv");
            if (!file.exists()) {
                String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                source.m_81352_((Component)Component.m_237113_((String)(warningColor + "No inventory found with this name!")));
                return 0;
            }
            CompoundTag compoundNBT = NbtIo.m_128937_((File)file);
            ListTag nbt = compoundNBT.m_128437_("Inventory", 10);
            player.m_150109_().m_36035_(nbt);
            String successColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.success.get());
            source.m_243053_((Component)Component.m_237113_((String)(successColor + "Inventory loaded successfully!")));
            return 1;
        }
        catch (CommandSyntaxException e) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.m_81352_((Component)Component.m_237113_((String)(warningColor + "Failed to get player: " + e.getMessage())));
            return 0;
        }
        catch (IOException e) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.m_81352_((Component)Component.m_237113_((String)(warningColor + "Failed to load inventory: " + e.getMessage())));
            return 0;
        }
    }

    private static int deleteInventory(CommandSourceStack source, String name) {
        try {
            ServerPlayer player = source.m_81375_();
            File inventoryFolder = CommandInventory.getInventoryFolder(source.m_81377_().m_129843_(LevelResource.f_78182_).toFile());
            File file = new File(inventoryFolder, String.valueOf(player.m_20148_()) + "_" + name + ".inv");
            if (!file.exists()) {
                String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                source.m_81352_((Component)Component.m_237113_((String)(warningColor + "No inventory found with this name!")));
                return 0;
            }
            if (file.delete()) {
                String successColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.success.get());
                source.m_81352_((Component)Component.m_237113_((String)(successColor + "Inventory deleted successfully!")));
                return 1;
            }
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.m_81352_((Component)Component.m_237113_((String)(warningColor + "Failed to delete inventory!")));
            return 0;
        }
        catch (CommandSyntaxException e) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.m_81352_((Component)Component.m_237113_((String)(warningColor + "Failed to get player: " + e.getMessage())));
            return 0;
        }
    }

    private static File getInventoryFolder(File worldFolder) {
        return new File(worldFolder, FOLDER_NAME + File.separator + INVENTORIES_FOLDER_NAME);
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
    }
}

