/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Registry;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.LevelResource;

public class CommandKit {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type KIT_MAP_TYPE = new TypeToken<Map<String, List<Map<String, Object>>>>(){}.getType();
    private static final String FOLDER_NAME = "sarosessentialsmod";
    private static final String KIT_FILE_NAME = "kits.json";
    private static final SuggestionProvider<CommandSourceStack> KIT_SUGGESTIONS = (context, builder) -> {
        File kitFile = CommandKit.getKitFile(((CommandSourceStack)context.getSource()).m_81377_().m_129843_(LevelResource.f_78182_).toFile());
        Map<String, List<Map<String, Object>>> kits = CommandKit.loadKits(kitFile);
        kits.keySet().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"kit").requires(source -> CommandKit.checkPermission(source))).then(Commands.m_82127_((String)"create").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> CommandKit.createKit((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"name")))))).then(Commands.m_82127_((String)"give").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).suggests(KIT_SUGGESTIONS).executes(context -> CommandKit.giveKit((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"name")))))).then(Commands.m_82127_((String)"delete").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).suggests(KIT_SUGGESTIONS).executes(context -> CommandKit.deleteKit((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"name"))))));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opKit.get()).booleanValue()) {
            return source.m_6761_(2);
        }
        return true;
    }

    private static int createKit(CommandContext<CommandSourceStack> context, String name) {
        try {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            System.out.println("Debug: Player - " + player.m_7755_().getString());
            File kitFile = CommandKit.getKitFile(((CommandSourceStack)context.getSource()).m_81377_().m_129843_(LevelResource.f_78182_).toFile());
            System.out.println("Debug: Kit file path - " + kitFile.getAbsolutePath());
            Map<String, List<Map<String, Object>>> kits = CommandKit.loadKits(kitFile);
            System.out.println("Debug: Kits loaded - " + kits.size());
            if (kits == null) {
                kits = new HashMap<String, List<Map<String, Object>>>();
            }
            if (kits.containsKey(name)) {
                String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)(warningColor + "A kit with that name already exists.")));
                return 0;
            }
            List hotbarItems = player.m_150109_().f_35974_.subList(0, 9);
            System.out.println("Debug: Hotbar items - " + hotbarItems.size());
            List serializedItems = hotbarItems.stream().map(CommandKit::serializeItemStack).collect(Collectors.toList());
            System.out.println("Debug: Serialized items - " + serializedItems.size());
            kits.put(name, serializedItems);
            CommandKit.saveKits(kitFile, kits);
            String successColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.success.get());
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)(successColor + "Kit created successfully.")));
            return 1;
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
            return 0;
        }
        catch (Exception e) {
            System.err.println("Error in createKit: " + e.getMessage());
            e.printStackTrace();
            return 0;
        }
    }

    private static int giveKit(CommandContext<CommandSourceStack> context, String name) {
        try {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            File kitFile = CommandKit.getKitFile(((CommandSourceStack)context.getSource()).m_81377_().m_129843_(LevelResource.f_78182_).toFile());
            Map<String, List<Map<String, Object>>> kits = CommandKit.loadKits(kitFile);
            System.out.println("Debug: Kits loaded - " + kits.size());
            if (kits == null || !kits.containsKey(name)) {
                String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)(warningColor + "No kit with that name exists.")));
                return 0;
            }
            List<Map<String, Object>> serializedItems = kits.get(name);
            int emptySlots = 0;
            for (ItemStack itemStack : player.m_150109_().f_35974_) {
                if (!itemStack.m_41619_()) continue;
                ++emptySlots;
            }
            if (serializedItems.size() > emptySlots) {
                String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)((String)warningColor + "Not enough space in inventory.")));
                return 0;
            }
            for (Map map : serializedItems) {
                ItemStack item = CommandKit.deserializeItemStack(map);
                player.m_150109_().m_36054_(item);
            }
            String successColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.success.get());
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)(successColor + "Kit given successfully.")));
            return 1;
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
            return 0;
        }
        catch (Exception e) {
            System.err.println("Error in giveKit: " + e.getMessage());
            e.printStackTrace();
            return 0;
        }
    }

    private static int deleteKit(CommandContext<CommandSourceStack> context, String name) {
        try {
            File kitFile = CommandKit.getKitFile(((CommandSourceStack)context.getSource()).m_81377_().m_129843_(LevelResource.f_78182_).toFile());
            Map<String, List<Map<String, Object>>> kits = CommandKit.loadKits(kitFile);
            if (kits == null || !kits.containsKey(name)) {
                String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)(warningColor + "No kit with that name exists.")));
                return 0;
            }
            kits.remove(name);
            CommandKit.saveKits(kitFile, kits);
            String successColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.success.get());
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)(successColor + "Kit deleted successfully.")));
            return 1;
        }
        catch (Exception e) {
            System.err.println("Error in deleteKit: " + e.getMessage());
            e.printStackTrace();
            return 0;
        }
    }

    private static File getKitFile(File worldFolder) {
        File kitFile;
        File modFolder = new File(worldFolder, FOLDER_NAME);
        if (!modFolder.exists()) {
            if (modFolder.mkdirs()) {
                System.out.println("Debug: Created mod folder - " + modFolder.getAbsolutePath());
            } else {
                System.err.println("Error: Could not create mod folder - " + modFolder.getAbsolutePath());
            }
        }
        if (!(kitFile = new File(modFolder, KIT_FILE_NAME)).exists()) {
            try {
                if (kitFile.createNewFile()) {
                    System.out.println("Debug: Created kit file - " + kitFile.getAbsolutePath());
                } else {
                    System.err.println("Error: Could not create kit file - " + kitFile.getAbsolutePath());
                }
            }
            catch (IOException e) {
                System.err.println("Error: IOException while creating kit file - " + e.getMessage());
                e.printStackTrace();
            }
        }
        return kitFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, List<Map<String, Object>>> loadKits(File kitFile) {
        if (!kitFile.exists()) {
            System.out.println("Debug: Kit file does not exist, returning empty kit map.");
            return new HashMap<String, List<Map<String, Object>>>();
        }
        try (FileReader reader = new FileReader(kitFile);){
            Map kits = (Map)GSON.fromJson((Reader)reader, KIT_MAP_TYPE);
            if (kits == null) {
                HashMap<String, List<Map<String, Object>>> hashMap = new HashMap<String, List<Map<String, Object>>>();
                return hashMap;
            }
            Map map = kits;
            return map;
        }
        catch (IOException e) {
            System.err.println("Error: IOException while loading kits - " + e.getMessage());
            e.printStackTrace();
            return new HashMap<String, List<Map<String, Object>>>();
        }
        catch (JsonSyntaxException e) {
            System.err.println("Error: JsonSyntaxException while loading kits - " + e.getMessage());
            e.printStackTrace();
            return new HashMap<String, List<Map<String, Object>>>();
        }
    }

    private static void saveKits(File kitFile, Map<String, List<Map<String, Object>>> kits) {
        try (FileWriter writer = new FileWriter(kitFile);){
            GSON.toJson(kits, (Appendable)writer);
            System.out.println("Debug: Kits saved to file - " + kitFile.getAbsolutePath());
        }
        catch (IOException e) {
            System.err.println("Error: IOException while saving kits - " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static Map<String, Object> serializeItemStack(ItemStack itemStack) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", Registry.f_122827_.m_7981_((Object)itemStack.m_41720_()).toString());
        map.put("count", itemStack.m_41613_());
        if (itemStack.m_41782_()) {
            map.put("tag", itemStack.m_41783_().toString());
        }
        return map;
    }

    private static ItemStack deserializeItemStack(Map<String, Object> map) {
        ItemStack itemStack = new ItemStack((ItemLike)Registry.f_122827_.m_7745_(new ResourceLocation(map.get("id").toString())), ((Double)map.get("count")).intValue());
        if (map.containsKey("tag")) {
            try {
                itemStack.m_41751_(TagParser.m_129359_((String)map.get("tag").toString()));
            }
            catch (CommandSyntaxException e) {
                System.err.println("Error: CommandSyntaxException while parsing item tag - " + e.getMessage());
                e.printStackTrace();
            }
        }
        return itemStack;
    }
}

