/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;

public class CommandPay {
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_ONLINE_PLAYERS = (context, builder) -> SharedSuggestionProvider.m_82967_((String[])((CommandSourceStack)context.getSource()).m_81377_().m_7641_(), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"pay").requires(source -> CommandPay.checkPermission(source))).then(Commands.m_82129_((String)"target", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_ONLINE_PLAYERS).then(Commands.m_82129_((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.01)).executes(context -> {
            ServerPlayer sender = ((CommandSourceStack)context.getSource()).m_81375_();
            String targetName = StringArgumentType.getString((CommandContext)context, (String)"target");
            double amount = DoubleArgumentType.getDouble((CommandContext)context, (String)"amount");
            ServerPlayer target = ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11255_(targetName);
            if (target != null) {
                if (CommandPay.hasEnoughBalance(sender, amount)) {
                    CommandPay.adjustBalance(sender, -amount);
                    CommandPay.adjustBalance(target, amount);
                    String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
                    String playerColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.playername.get());
                    String senderColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.sendername.get());
                    sender.m_213846_((Component)Component.m_237113_((String)(standardColor + "You paid " + senderColor + amount + standardColor + " to " + playerColor + target.m_7755_().getString())));
                    target.m_213846_((Component)Component.m_237113_((String)(standardColor + "You received " + senderColor + amount + standardColor + " from " + playerColor + sender.m_7755_().getString())));
                } else {
                    String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                    sender.m_213846_((Component)Component.m_237113_((String)(warningColor + "Not enough money.")));
                }
            } else {
                String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                sender.m_213846_((Component)Component.m_237113_((String)(warningColor + "Player not found.")));
            }
            return 1;
        }))));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opPay.get()).booleanValue()) {
            return source.m_6761_(2);
        }
        return true;
    }

    private static boolean hasEnoughBalance(ServerPlayer player, double amount) {
        File bankFile = CommandPay.getBankFile(player);
        try {
            String content = new String(Files.readAllBytes(bankFile.toPath()));
            double balance = Double.parseDouble(content);
            return balance >= amount;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static void adjustBalance(ServerPlayer player, double amount) {
        File bankFile = CommandPay.getBankFile(player);
        try {
            String content = new String(Files.readAllBytes(bankFile.toPath()));
            double balance = Double.parseDouble(content);
            balance += amount;
            try (FileWriter writer = new FileWriter(bankFile);){
                writer.write(Double.toString(balance));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static File getBankFile(ServerPlayer player) {
        File worldFolder = player.m_20194_().m_129843_(LevelResource.f_78182_).toFile();
        File modFolder = new File(worldFolder, "sarosessentialsmod/bank");
        if (!modFolder.exists()) {
            modFolder.mkdirs();
        }
        return new File(modFolder, player.m_20148_().toString() + ".bank");
    }
}

