/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.sarocesch.sarosessentialsmod.SpawnPoint;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CommandSetspawn {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"setspawn").requires(source -> CommandSetspawn.checkPermission(source))).executes(context -> CommandSetspawn.setSpawn((CommandSourceStack)context.getSource())));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opSpawn.get()).booleanValue()) {
            return source.m_6761_(2);
        }
        return true;
    }

    private static int setSpawn(CommandSourceStack source) {
        try {
            ServerPlayer player = source.m_81375_();
            Vec3 position = player.m_20182_();
            Vec2 rotation = player.m_20155_();
            String dimension = player.m_9236_().m_46472_().m_135782_().toString();
            SpawnPoint spawnPoint = new SpawnPoint(dimension, position, rotation);
            CommandSetspawn.saveSpawnPoint(source, spawnPoint);
            String successColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.success.get());
            source.m_243053_((Component)Component.m_237113_((String)(successColor + "Spawn point set successfully!")));
            return 1;
        }
        catch (Exception e) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.m_81352_((Component)Component.m_237113_((String)(warningColor + "Failed to set spawn point: " + e.getMessage())));
            return 0;
        }
    }

    private static void saveSpawnPoint(CommandSourceStack source, SpawnPoint spawnPoint) throws IOException {
        File worldFolder = source.m_81377_().m_129843_(LevelResource.f_78182_).resolve("sarosessentialsmod").toFile();
        if (!worldFolder.exists()) {
            worldFolder.mkdirs();
        }
        File spawnFile = new File(worldFolder, "spawn.info");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (FileWriter writer = new FileWriter(spawnFile);){
            gson.toJson((Object)spawnPoint, (Appendable)writer);
        }
    }
}

