/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;

public class CommandSetwarp {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type WARP_MAP_TYPE = new TypeToken<Map<String, Warp>>(){}.getType();
    private static final String FOLDER_NAME = "sarosessentialsmod";
    private static final String WARP_FILE_NAME = "warps.json";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"setwarp").requires(source -> CommandSetwarp.checkPermission(source))).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> CommandSetwarp.setWarp((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"name")))));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opSpawn.get()).booleanValue()) {
            return source.m_6761_(2);
        }
        return true;
    }

    private static int setWarp(CommandContext<CommandSourceStack> context, String name) {
        try {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ServerLevel world = player.m_9236_();
            BlockPos position = player.m_20183_();
            float yaw = player.m_146908_();
            float pitch = player.m_146909_();
            File warpFile = CommandSetwarp.getWarpFile(((CommandSourceStack)context.getSource()).m_81377_().m_129843_(LevelResource.f_78182_).toFile());
            if (warpFile == null) {
                String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)(warningColor + "Error: Warp file could not be created.")));
                return 0;
            }
            Map<String, Warp> warps = CommandSetwarp.loadWarps(warpFile);
            if (warps == null) {
                String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)(warningColor + "Error: Failed to load warps.")));
                return 0;
            }
            if (warps.containsKey(name)) {
                String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)(warningColor + "A warp with that name already exists.")));
                return 0;
            }
            Warp warp = new Warp(world.m_46472_().m_135782_().toString(), position, yaw, pitch);
            warps.put(name, warp);
            CommandSetwarp.saveWarps(warpFile, warps);
            String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)(standardColor + "Warp set successfully.")));
            return 1;
        }
        catch (CommandSyntaxException e) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)(warningColor + "CommandSyntaxException: " + e.getMessage())));
            e.printStackTrace();
            return 0;
        }
        catch (Exception e) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)(warningColor + "Exception: " + e.getMessage())));
            e.printStackTrace();
            return 0;
        }
    }

    private static File getWarpFile(File worldFolder) {
        File warpFile;
        File modFolder = new File(worldFolder, FOLDER_NAME);
        if (!modFolder.exists()) {
            modFolder.mkdirs();
        }
        if (!(warpFile = new File(modFolder, WARP_FILE_NAME)).exists()) {
            try {
                warpFile.createNewFile();
                try (FileWriter writer = new FileWriter(warpFile);){
                    writer.write("{}");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return warpFile;
    }

    private static Map<String, Warp> loadWarps(File warpFile) {
        Map map;
        if (!warpFile.exists()) {
            return new HashMap<String, Warp>();
        }
        FileReader reader = new FileReader(warpFile);
        try {
            map = (Map)GSON.fromJson((Reader)reader, WARP_MAP_TYPE);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return new HashMap<String, Warp>();
            }
        }
        reader.close();
        return map;
    }

    private static void saveWarps(File warpFile, Map<String, Warp> warps) {
        try (FileWriter writer = new FileWriter(warpFile);){
            GSON.toJson(warps, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static class Warp {
        private final String dimension;
        private final BlockPos position;
        private final float yaw;
        private final float pitch;

        public Warp(String dimension, BlockPos position, float yaw, float pitch) {
            this.dimension = dimension;
            this.position = position;
            this.yaw = yaw;
            this.pitch = pitch;
        }

        public String getDimension() {
            return this.dimension;
        }

        public BlockPos getPosition() {
            return this.position;
        }

        public float getYaw() {
            return this.yaw;
        }

        public float getPitch() {
            return this.pitch;
        }
    }
}

