/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public class CommandTempban {
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_ONLINE_PLAYERS = (context, builder) -> SharedSuggestionProvider.m_82967_((String[])((CommandSourceStack)context.getSource()).m_81377_().m_7641_(), (SuggestionsBuilder)builder);
    private static final Map<UUID, Long> tempBanEndTimes = new HashMap<UUID, Long>();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tempban").requires(source -> CommandTempban.checkPermission(source))).then(Commands.m_82129_((String)"target", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_ONLINE_PLAYERS).then(Commands.m_82129_((String)"time", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"reason", (ArgumentType)StringArgumentType.string()).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            String targetName = StringArgumentType.getString((CommandContext)context, (String)"target");
            String timeString = StringArgumentType.getString((CommandContext)context, (String)"time");
            String reason = StringArgumentType.getString((CommandContext)context, (String)"reason");
            ServerPlayer target = source.m_81377_().m_6846_().m_11255_(targetName);
            if (target != null) {
                long banDuration = CommandTempban.parseTimeString(timeString);
                if (banDuration > 0L) {
                    CommandTempban.banPlayer(source, target, banDuration, reason, timeString);
                    String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
                    source.m_243053_((Component)Component.m_237113_((String)(standardColor + targetName + " has been temporarily banned for " + timeString + " for reason: " + reason)));
                } else {
                    String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                    source.m_81352_((Component)Component.m_237113_((String)(warningColor + "Invalid time format. Valid Formats: 1s = seconds 1m = minutes 1h = hour 1d = day 1w = week")));
                }
            } else {
                String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                source.m_81352_((Component)Component.m_237113_((String)(warningColor + "Player not found.")));
            }
            return 1;
        })))));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opTempban.get()).booleanValue()) {
            return source.m_6761_(2);
        }
        return true;
    }

    private static long parseTimeString(String timeString) {
        long duration = 0L;
        char unit = timeString.charAt(timeString.length() - 1);
        String number = timeString.substring(0, timeString.length() - 1);
        try {
            int timeValue = Integer.parseInt(number);
            switch (unit) {
                case 's': {
                    duration = TimeUnit.SECONDS.toMillis(timeValue);
                    break;
                }
                case 'm': {
                    duration = TimeUnit.MINUTES.toMillis(timeValue);
                    break;
                }
                case 'h': {
                    duration = TimeUnit.HOURS.toMillis(timeValue);
                    break;
                }
                case 'd': {
                    duration = TimeUnit.DAYS.toMillis(timeValue);
                    break;
                }
                case 'w': {
                    duration = TimeUnit.DAYS.toMillis(timeValue * 7);
                    break;
                }
                default: {
                    duration = -1L;
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            duration = -1L;
        }
        return duration;
    }

    private static void banPlayer(CommandSourceStack source, ServerPlayer player, long duration, String reason, String timeString) {
        PlayerList playerList = player.m_20194_().m_6846_();
        UUID playerUUID = player.m_20148_();
        tempBanEndTimes.put(playerUUID, System.currentTimeMillis() + duration);
        String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
        String banMessage = warningColor + "You have been temporarily banned for " + timeString + " for reason: " + reason + ".\nTime left: " + CommandTempban.formatTime(duration);
        player.f_8906_.m_9942_((Component)Component.m_237113_((String)banMessage));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        long currentTime = System.currentTimeMillis();
        tempBanEndTimes.entrySet().removeIf(entry -> {
            if (currentTime > (Long)entry.getValue()) {
                CommandTempban.unbanPlayer((UUID)entry.getKey());
                return true;
            }
            return false;
        });
    }

    private static void unbanPlayer(UUID playerUUID) {
        PlayerList playerList = ServerLifecycleHooks.getCurrentServer().m_6846_();
        GameProfile profile = new GameProfile(playerUUID, null);
        playerList.m_11295_().m_11393_((Object)profile);
    }

    private static String formatTime(long millis) {
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        long weeks = days / 7L;
        if (weeks > 0L) {
            return weeks + "w";
        }
        if (days > 0L) {
            return days + "d";
        }
        if (hours > 0L) {
            return hours + "h";
        }
        if (minutes > 0L) {
            return minutes + "m";
        }
        return seconds + "s";
    }
}

