/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CommandTpoffline {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tpoffline").requires(source -> CommandTpoffline.checkPermission(source))).then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            MinecraftServer server = ((CommandSourceStack)context.getSource()).m_81377_();
            server.m_6846_().m_11314_().stream().filter(player -> !player.f_8906_.f_9742_.m_129536_()).forEach(player -> builder.suggest(player.m_7755_().getString()));
            return builder.buildFuture();
        }).executes(context -> {
            String playerName = StringArgumentType.getString((CommandContext)context, (String)"player");
            MinecraftServer server = ((CommandSourceStack)context.getSource()).m_81377_();
            ServerPlayer targetPlayer = server.m_6846_().m_11255_(playerName);
            if (targetPlayer == null) {
                String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)(warningColor + "Player not found or is online.")));
                return 0;
            }
            ServerLevel world = targetPlayer.m_9236_();
            BlockPos pos = targetPlayer.m_20183_();
            ((CommandSourceStack)context.getSource()).m_81375_().m_8999_(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), targetPlayer.m_146908_(), targetPlayer.m_146909_());
            String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)(standardColor + "Teleported to " + playerName)));
            return 1;
        })));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opTempban.get()).booleanValue()) {
            return source.m_6761_(2);
        }
        return true;
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandTpoffline.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

