/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraftforge.network.NetworkHooks;

public class CommandTrash {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"trash").requires(source -> CommandTrash.checkPermission(source))).executes(context -> CommandTrash.openTrash((CommandContext<CommandSourceStack>)context, ((CommandSourceStack)context.getSource()).m_81375_()))).then(Commands.m_82129_((String)"target", (ArgumentType)StringArgumentType.string()).suggests(CommandTrash::suggestPlayers).executes(context -> CommandTrash.openTrash((CommandContext<CommandSourceStack>)context, CommandTrash.getPlayerByName((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"target"))))));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opTrash.get()).booleanValue()) {
            return source.m_6761_(2);
        }
        return true;
    }

    private static CompletableFuture<Suggestions> suggestPlayers(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        List players = ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11314_();
        for (ServerPlayer player : players) {
            builder.suggest(player.m_7755_().getString());
        }
        return builder.buildFuture();
    }

    private static ServerPlayer getPlayerByName(CommandContext<CommandSourceStack> context, String playerName) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11255_(playerName);
        if (player == null) {
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().create();
        }
        return player;
    }

    private static int openTrash(CommandContext<CommandSourceStack> context, ServerPlayer player) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((id, inv, playerIn) -> {
            TrashInventory trashInventory = new TrashInventory((Player)player, 27);
            return ChestMenu.m_39237_((int)id, (Inventory)inv, (Container)trashInventory);
        }, (Component)Component.m_237113_((String)"Trash")), buffer -> {});
        return 1;
    }

    private static class TrashInventory
    extends Inventory {
        public TrashInventory(Player player, int size) {
            super(player);
        }
    }
}

