/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class CommandWorkbench {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"workbench").requires(source -> CommandWorkbench.checkPermission(source))).executes(context -> CommandWorkbench.execute((CommandSourceStack)context.getSource())));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opWorkbench.get()).booleanValue()) {
            return source.m_6761_(2);
        }
        return true;
    }

    private static int execute(CommandSourceStack source) {
        Entity entity = source.m_81373_();
        if (!(entity instanceof ServerPlayer)) {
            source.m_81352_((Component)Component.m_237113_((String)"Only players can use this command!"));
            return 0;
        }
        ServerPlayer player = (ServerPlayer)entity;
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((containerId, playerInventory, _player) -> new WorkbenchCraftingMenu(containerId, playerInventory), (Component)Component.m_237115_((String)"container.crafting")), buf -> buf.m_130062_(new BlockHitResult(Vec3.f_82478_, Direction.UP, new BlockPos(player.m_146903_(), player.m_146904_(), player.m_146907_()), false)));
        return 1;
    }

    private static class WorkbenchCraftingMenu
    extends CraftingMenu {
        private boolean isUpdating = false;
        private final Player player;

        public WorkbenchCraftingMenu(int containerId, Inventory playerInventory) {
            super(containerId, playerInventory);
            this.player = playerInventory.f_35978_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void m_6199_(Container container) {
            if (this.isUpdating) {
                return;
            }
            this.isUpdating = true;
            try {
                Player player;
                Level level = this.player.m_9236_();
                if (!level.f_46443_ && (player = this.player) instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CraftingContainer craftSlots = new CraftingContainer((AbstractContainerMenu)this, 3, 3);
                    for (int i = 0; i < 9; ++i) {
                        craftSlots.m_6836_(i, this.m_38853_(i + 1).m_7993_());
                    }
                    ItemStack result = level.m_7654_().m_129894_().m_44015_(RecipeType.f_44107_, (Container)craftSlots, level).map(recipe -> recipe.m_5874_((Container)craftSlots)).orElse(ItemStack.f_41583_);
                    this.m_38853_(0).m_5852_(result);
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(this.f_38840_, this.m_182424_(), 0, result));
                }
            }
            finally {
                this.isUpdating = false;
            }
        }
    }
}

