/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.util.ArrayList;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemLore;

public class CommandAddlore {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"addlore").requires(source -> true)).then(Commands.argument((String)"lore", (ArgumentType)StringArgumentType.string()).executes(CommandAddlore::addLore)));
    }

    private static int addLore(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.getPlayerOrException();
        String lore = StringArgumentType.getString(context, (String)"lore");
        ItemStack itemStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (itemStack.isEmpty()) {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            source.sendFailure((Component)Component.literal((String)(warningColor + "You must hold an item in your main hand to add lore.")));
            return 0;
        }
        MutableComponent loreLine = Component.literal((String)lore).withStyle(style -> style.withColor(0x808080));
        if (itemStack.has(DataComponents.LORE)) {
            ArrayList<MutableComponent> currentLore = new ArrayList<MutableComponent>(((ItemLore)itemStack.get(DataComponents.LORE)).lines());
            currentLore.add(loreLine);
            itemStack.set(DataComponents.LORE, (Object)new ItemLore(currentLore));
        } else {
            ArrayList<MutableComponent> newLore = new ArrayList<MutableComponent>();
            newLore.add(loreLine);
            itemStack.set(DataComponents.LORE, (Object)new ItemLore(newLore));
        }
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        String playerColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.playername.get());
        source.sendSystemMessage((Component)Component.literal((String)(standardColor + "Added lore: " + playerColor + lore)));
        return 1;
    }
}

