/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CommandBack {
    private static final Map<UUID, BlockPos> lastPositions = new HashMap<UUID, BlockPos>();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"back").requires(source -> CommandBack.checkPermission(source))).executes(CommandBack::teleportBack));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opBack.get()).booleanValue()) {
            // empty if block
        }
        return true;
    }

    private static int teleportBack(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        UUID playerUUID = player.getUUID();
        if (lastPositions.containsKey(playerUUID)) {
            BlockPos lastPos = lastPositions.get(playerUUID);
            player.teleportTo((double)lastPos.getX(), (double)lastPos.getY(), (double)lastPos.getZ());
            String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)(standardColor + "Teleported back to your last location.")));
        } else {
            String warningColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)(warningColor + "No last location found.")));
        }
        return 1;
    }

    @SubscribeEvent
    public static void onPlayerTeleport(CommandEvent event) {
        CommandSourceStack source;
        if ((event.getParseResults().getReader().getString().startsWith("/tp") || event.getParseResults().getReader().getString().startsWith("/warp") || event.getParseResults().getReader().getString().startsWith("/tpa") || event.getParseResults().getReader().getString().startsWith("/home")) && (source = (CommandSourceStack)event.getParseResults().getContext().getSource()).getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)source.getEntity();
            CommandBack.saveLastPosition(player);
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            CommandBack.saveLastPosition(player);
        }
    }

    private static void saveLastPosition(ServerPlayer player) {
        lastPositions.put(player.getUUID(), player.blockPosition());
    }
}

