/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosessentialsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosessentialsmod.config.Dateiverwaltung;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class CommandClean {
    private static final Map<ServerPlayer, ItemStack[]> undoMap = new HashMap<ServerPlayer, ItemStack[]>();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"clean").requires(source -> CommandClean.checkPermission(source))).executes(CommandClean::cleanSelf)).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.suggest((String[])((CommandSourceStack)context.getSource()).getServer().getPlayerNames(), (SuggestionsBuilder)builder)).executes(context -> CommandClean.cleanOther((CommandContext<CommandSourceStack>)context, Collections.singletonList(StringArgumentType.getString((CommandContext)context, (String)"player"))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"cleanundo").requires(source -> CommandClean.checkPermission(source))).executes(CommandClean::undoSelf)).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.suggest((String[])((CommandSourceStack)context.getSource()).getServer().getPlayerNames(), (SuggestionsBuilder)builder)).executes(context -> CommandClean.undoOther((CommandContext<CommandSourceStack>)context, Collections.singletonList(StringArgumentType.getString((CommandContext)context, (String)"player"))))));
    }

    private static boolean checkPermission(CommandSourceStack source) {
        if (((Boolean)Dateiverwaltung.opClean.get()).booleanValue()) {
            // empty if block
        }
        return true;
    }

    private static int cleanSelf(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        CommandClean.saveInventory(player);
        CommandClean.cleanInventory(player);
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)(standardColor + "Cleared your inventory.")));
        return 1;
    }

    private static int cleanOther(CommandContext<CommandSourceStack> context, Collection<String> targets) {
        for (String target : targets) {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayerByName(target);
            if (player != null) {
                CommandClean.saveInventory(player);
                CommandClean.cleanInventory(player);
                String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
                String playerColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.playername.get());
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)(standardColor + "Cleared " + playerColor + target + standardColor + "'s inventory.")));
                continue;
            }
            String errorColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)(errorColor + "Player " + target + " not found.")));
        }
        return 1;
    }

    private static void saveInventory(ServerPlayer player) {
        Inventory inventory = player.getInventory();
        ItemStack[] savedItems = new ItemStack[inventory.getContainerSize()];
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            savedItems[i] = inventory.getItem(i).copy();
        }
        undoMap.put(player, savedItems);
    }

    private static void cleanInventory(ServerPlayer player) {
        Inventory inventory = player.getInventory();
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            if (i >= 36 && i <= 39) continue;
            inventory.setItem(i, ItemStack.EMPTY);
        }
        inventory.setChanged();
    }

    private static int undoSelf(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        CommandClean.restoreInventory(player);
        String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)(standardColor + "Your inventory has been restored.")));
        return 1;
    }

    private static int undoOther(CommandContext<CommandSourceStack> context, Collection<String> targets) {
        for (String target : targets) {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayerByName(target);
            if (player != null) {
                CommandClean.restoreInventory(player);
                String standardColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.standard.get());
                String playerColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.playername.get());
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)(standardColor + "Restored " + playerColor + target + standardColor + "'s inventory.")));
                continue;
            }
            String errorColor = Dateiverwaltung.getColorCode((String)Dateiverwaltung.warning.get());
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)(errorColor + "Player " + target + " not found.")));
        }
        return 1;
    }

    private static void restoreInventory(ServerPlayer player) {
        ItemStack[] savedInventory = undoMap.get(player);
        if (savedInventory != null) {
            Inventory inventory = player.getInventory();
            for (int i = 0; i < savedInventory.length && i < inventory.getContainerSize(); ++i) {
                inventory.setItem(i, savedInventory[i]);
            }
            inventory.setChanged();
        }
    }
}

